package org.nuiton.topia.it.legacy.topiatest;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.it.legacy.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 12 10:36:34 CET 2013")
public abstract class GeneratedEmployeTopiaDao<E extends Employe> extends AbstractPersonneTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Employe.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Employe;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            DepartmentTopiaDao dao = topiaDaoSupplier
                    .getDao(Department.class, DepartmentTopiaDao.class);
            List<Department> list = dao
                    .forProperties(Department.PROPERTY_LEADER, entity)
                    .findAll();
            for (Department item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getLeader())) {
                    item.setLeader(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSalaryIn(Iterable<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Employe.PROPERTY_SALARY, (Iterable) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSalaryEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Employe.PROPERTY_SALARY, v);
        return result;
    }

    @Deprecated
    public E findBySalary(int v) {
        return forSalaryEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySalary(int v) {
        return forSalaryEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Company.class) {
            CompanyTopiaDao dao =
                topiaDaoSupplier.getDao(Company.class, CompanyTopiaDao.class);
            tmp = dao.forEmployeContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Department.class) {
            DepartmentTopiaDao dao =
                topiaDaoSupplier.getDao(Department.class, DepartmentTopiaDao.class);
            tmp = dao.forLeaderEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Company.class, entity);
        if (!list.isEmpty()) {
            result.put(Company.class, list);
        }

        list = findUsages(Department.class, entity);
        if (!list.isEmpty()) {
            result.put(Department.class, list);
        }

        return result;
    }

} //GeneratedEmployeTopiaDao<E extends Employe>
