/*
 * #%L
 * Nuiton Validator
 * $Id: SkipableRequiredStringFieldValidator.java 2588 2013-07-20 14:39:20Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-validator/tags/nuiton-validator-3.0-alpha-1/src/main/java/org/nuiton/validator/xwork2/field/SkipableRequiredStringFieldValidator.java $
 * %%
 * Copyright (C) 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;

/**
 * @author jcouteau <couteau@codelutin.com>
 * @since 2.3
 */
public class SkipableRequiredStringFieldValidator extends NuitonFieldValidatorSupport {

    @Override
    protected void validateWhenNotSkip(Object object) throws ValidationException {
        String fieldName = getFieldName();
        Object value = getFieldValue(fieldName, object);

        if (value == null || !(value instanceof String) || "".equals(value)) {
            addFieldError(fieldName, object);
        }
    }
}
