/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.plugin;

import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.config.plugin.io.ConfigModelIO;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginHelper;

abstract class ConfigMojoSupport
extends AbstractPlugin {
    @Parameter(property="config.format", defaultValue="ini")
    private String format;
    @Parameter(property="config.modelFile")
    private File modelFile;
    @Parameter(property="config.modelDirectory", defaultValue="${basedir}/src/main/config", required=true)
    private File modelDirectory;
    @Parameter(property="config.verbose", defaultValue="${maven.verbose}")
    private boolean verbose;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component(role=ConfigModelIO.class)
    private Map<String, ConfigModelIO> configModelIs;

    ConfigMojoSupport() {
    }

    protected void init() throws Exception {
        if (!this.configModelIs.containsKey(this.format)) {
            throw new MojoExecutionException("Don't know format: " + this.format + ", use one of these: " + this.configModelIs.keySet());
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Use format: " + this.format));
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    void setModelFile(String name) {
        this.modelFile = PluginHelper.getFile((File)this.modelDirectory, (String[])new String[]{name + "." + this.format});
    }

    ConfigModelIO getIO() {
        return this.configModelIs.get(this.format);
    }

    File getModelFile() {
        return this.modelFile;
    }
}

