/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.pagination;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.nuiton.util.pagination.PaginationOrder;
import org.nuiton.util.pagination.PaginationParameter;

public class PaginationResult<O>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected List<O> elements;
    protected long count;
    protected PaginationParameter currentPage;

    protected PaginationResult(List<O> elements, long count, PaginationParameter currentPage) {
        this.elements = elements;
        this.count = count;
        this.currentPage = currentPage;
    }

    public static <T> PaginationResult<T> of(List<T> elements, long count, PaginationParameter currentPage) {
        PaginationResult<T> result = new PaginationResult<T>(elements, count, currentPage);
        return result;
    }

    public static <T> PaginationResult<T> fromFullList(List<T> fullList, PaginationParameter requestedPage) {
        List<T> subList;
        int startIndex = requestedPage.getStartIndex();
        if (requestedPage.isAll()) {
            subList = fullList;
        } else if (startIndex >= fullList.size()) {
            subList = new LinkedList<T>();
        } else {
            int toIndex = Math.min(requestedPage.getEndIndex() + 1, fullList.size());
            subList = fullList.subList(startIndex, toIndex);
        }
        PaginationResult<T> result = PaginationResult.of(subList, fullList.size(), requestedPage);
        return result;
    }

    public List<O> getElements() {
        return this.elements;
    }

    public long getCount() {
        return this.count;
    }

    public PaginationParameter getCurrentPage() {
        return this.currentPage;
    }

    public PaginationParameter getNextPage() {
        int nextPageNumber = this.currentPage.getPageNumber() + 1;
        int pageSize = this.currentPage.getPageSize();
        List<PaginationOrder> orderClauses = this.currentPage.getOrderClauses();
        PaginationParameter result = PaginationParameter.builder(nextPageNumber, pageSize).addOrderClauses(orderClauses).build();
        return result;
    }

    public PaginationParameter getPreviousPage() {
        Preconditions.checkState((boolean)this.hasPreviousPage(), (Object)"You cannot get a previous page to the first one");
        int previousPageNumber = this.currentPage.getPageNumber() - 1;
        int pageSize = this.currentPage.getPageSize();
        List<PaginationOrder> orderClauses = this.currentPage.getOrderClauses();
        PaginationParameter result = PaginationParameter.builder(previousPageNumber, pageSize).addOrderClauses(orderClauses).build();
        return result;
    }

    public PaginationParameter getFirstPage() {
        int firstPageNumber = 0;
        int pageSize = this.currentPage.getPageSize();
        List<PaginationOrder> orderClauses = this.currentPage.getOrderClauses();
        PaginationParameter result = PaginationParameter.builder(firstPageNumber, pageSize).addOrderClauses(orderClauses).build();
        return result;
    }

    public PaginationParameter getLastPage() {
        int lastPageNumber = Math.max(0, this.getPageCount() - 1);
        int pageSize = this.currentPage.getPageSize();
        List<PaginationOrder> orderClauses = this.currentPage.getOrderClauses();
        PaginationParameter result = PaginationParameter.builder(lastPageNumber, pageSize).addOrderClauses(orderClauses).build();
        return result;
    }

    public int getPageCount() {
        int pageCount = 1;
        int pageSize = this.currentPage.getPageSize();
        if (pageSize >= 1) {
            double countDouble = Long.valueOf(this.count).doubleValue();
            double pageSizeDouble = Integer.valueOf(pageSize).doubleValue();
            double pageNumberDouble = Math.ceil(countDouble / pageSizeDouble);
            pageCount = Double.valueOf(pageNumberDouble).intValue();
        }
        return pageCount;
    }

    public boolean hasNextPage() {
        int lastPageNumber = this.getPageCount() - 1;
        boolean result = this.currentPage.getPageNumber() < lastPageNumber;
        return result;
    }

    public boolean hasPreviousPage() {
        boolean result = this.currentPage.getPageNumber() > 0;
        return result;
    }

    public <T> PaginationResult<T> transform(Function<? super O, ? extends T> function) {
        Iterable transformed = Iterables.transform(this.getElements(), function);
        LinkedList transformedElements = Lists.newLinkedList((Iterable)transformed);
        PaginationResult<T> result = PaginationResult.of(transformedElements, this.getCount(), this.getCurrentPage());
        return result;
    }
}

