/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.io.properties;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Properties;
import org.nuiton.config.io.ApplicationConfigIO;
import org.nuiton.config.io.ApplicationConfigReadFormat;
import org.nuiton.config.io.ApplicationConfigReadPropertiesException;
import org.nuiton.config.io.ApplicationConfigWritePropertiesException;

public class ApplicationConfigIOProperties
implements ApplicationConfigIO {
    @Override
    public boolean accept(ApplicationConfigReadFormat readFormat) {
        return ApplicationConfigReadFormat.properties.equals((Object)readFormat);
    }

    @Override
    public Properties readProperties(URL url, String encoding) throws ApplicationConfigReadPropertiesException {
        Properties properties = new Properties();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), encoding));){
            properties.load(reader);
        }
        catch (Exception e) {
            throw new ApplicationConfigReadPropertiesException("Can't read properties file: " + url, e);
        }
        return properties;
    }

    @Override
    public void writeProperties(Properties properties, File file, String encoding, String comment) throws ApplicationConfigWritePropertiesException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));){
            properties.store(writer, comment);
        }
        catch (Exception e) {
            throw new ApplicationConfigWritePropertiesException("Can't store properties file: " + file, e);
        }
    }
}

