/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.io.xpp3;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.nuiton.io.xpp3.PropertyMapper;
import org.nuiton.io.xpp3.Xpp3Helper;
import org.nuiton.io.xpp3.Xpp3Reader;

public abstract class AbstractXpp3Reader<O>
implements Xpp3Reader<O> {
    protected boolean addDefaultEntities = true;
    protected final Class<O> type;
    protected String rootTagName;
    protected String arrayRootTagName;
    protected Map<String, PropertyMapper> allMappers;

    protected abstract void initMappers() throws IntrospectionException;

    protected AbstractXpp3Reader(Class<O> type, String rootTagName) {
        this(type, null, rootTagName);
    }

    protected AbstractXpp3Reader(Class<O> type, String arrayRootTagName, String rootTagName) {
        this.type = type;
        this.rootTagName = rootTagName;
        this.arrayRootTagName = arrayRootTagName;
        this.allMappers = new TreeMap<String, PropertyMapper>();
        try {
            this.initMappers();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("could not init " + this + " for reason " + e.getMessage(), e);
        }
    }

    @Override
    public Class<O> getType() {
        return this.type;
    }

    @Override
    public String getRootTagName() {
        return this.rootTagName;
    }

    @Override
    public void setRootTagName(String rootTagName) {
        this.rootTagName = rootTagName;
    }

    @Override
    public String getArrayRootTagName() {
        return this.arrayRootTagName;
    }

    @Override
    public void setParentRootTagName(String parentRootTagName) {
        this.arrayRootTagName = parentRootTagName;
    }

    @Override
    public boolean isAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    @Override
    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    @Override
    public O read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    @Override
    public O read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        if (this.addDefaultEntities) {
            Xpp3Helper.addDefaultEntities((XmlPullParser)parser);
        }
        parser.next();
        O result = this.read(this.getRootTagName(), this.getType(), (XmlPullParser)parser, strict);
        parser.next();
        this.checkEndOfXml((XmlPullParser)parser);
        return result;
    }

    @Override
    public O[] readArray(Reader reader) throws IOException, XmlPullParserException {
        return this.readArray(reader, true);
    }

    @Override
    public O[] readArray(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        if (this.addDefaultEntities) {
            Xpp3Helper.addDefaultEntities((XmlPullParser)parser);
        }
        parser.next();
        parser.getEventType();
        O[] result = this.readArray(this.getArrayRootTagName(), this.getRootTagName(), this.getType(), (XmlPullParser)parser, strict);
        parser.next();
        this.checkEndOfXml((XmlPullParser)parser);
        return result;
    }

    public Map<String, PropertyMapper> getMappers(Class<?> srcType) {
        TreeMap<String, PropertyMapper> result = new TreeMap<String, PropertyMapper>();
        String prefix = srcType.getName() + "#";
        for (Map.Entry<String, PropertyMapper> e : this.allMappers.entrySet()) {
            if (!e.getKey().startsWith(prefix)) continue;
            result.put(e.getValue().getTagName(), e.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T read(String rootTagName, Class<T> type, XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        this.gotoNextOpenTag(rootTagName, parser);
        T result = null;
        try {
            result = type.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("could not instanciate a new " + this.getType().getName() + " for reason : " + ex.getMessage(), ex);
        }
        Map<String, PropertyMapper> mappers = this.getMappers(type);
        HashSet<String> parsed = new HashSet<String>();
        try {
            int eventType = parser.next();
            while (true) {
                this.checkNotEndOfXml(parser, rootTagName);
                if (eventType == 2) {
                    PropertyMapper mapper = mappers.get(parser.getName());
                    if (mapper != null) {
                        mapper.setProperty(result, parser, parsed, strict);
                    } else if (strict) {
                        throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
                    }
                } else if (eventType == 3 && parser.getName().equals(rootTagName)) break;
                eventType = parser.next();
            }
            T t = result;
            return t;
        }
        finally {
            parsed.clear();
            if (mappers != null) {
                mappers.clear();
            }
        }
    }

    protected <T> T[] readArray(String parentRootTagName, String rootTagName, Class<T> type, XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        this.gotoNextOpenTag(parentRootTagName, parser);
        ArrayList<T> results = new ArrayList<T>();
        boolean addChild = false;
        boolean quit = false;
        while (!quit) {
            block3: {
                int eventType;
                addChild = false;
                quit = false;
                do {
                    this.checkNotEndOfXml(parser, parentRootTagName);
                    eventType = parser.next();
                    if (eventType != 2 || !rootTagName.equals(parser.getName())) continue;
                    addChild = true;
                    break block3;
                } while (eventType != 3 || !parentRootTagName.equals(parser.getName()));
                quit = true;
            }
            if (addChild) {
                T result = this.read(rootTagName, type, parser, strict);
                results.add(result);
                continue;
            }
            if (quit) continue;
            throw new XmlPullParserException("should be on " + parentRootTagName + " but was not : " + parser.getName());
        }
        return results.toArray((Object[])Array.newInstance(type, results.size()));
    }

    protected int gotoNextOpenTag(String tagName, XmlPullParser parser) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        while (eventType != 2 || !parser.getName().equals(tagName)) {
            this.checkNotEndOfXml(parser, tagName);
            eventType = parser.next();
        }
        return eventType;
    }

    protected void checkNotEndOfXml(XmlPullParser parser, String tagName) throws XmlPullParserException {
        if (parser.getEventType() == 1) {
            throw new XmlPullParserException("end of document found... but required at least the ending tag " + tagName);
        }
    }

    protected void checkEndOfXml(XmlPullParser parser) throws XmlPullParserException {
        if (parser.getEventType() != 1) {
            throw new XmlPullParserException("should be at the end of document but was not... : " + parser.getName());
        }
    }
}

