/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin.report;

import java.util.Locale;
import java.util.Map;
import org.apache.maven.reporting.MavenReportException;
import org.nuiton.jredmine.RedmineServiceException;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.plugin.IssueCollectorConfiguration;
import org.nuiton.jredmine.plugin.IssuesCollector;
import org.nuiton.jredmine.plugin.report.AbstractRedmineReport;
import org.nuiton.jredmine.plugin.report.IssueReportGenerator;
import org.nuiton.plugin.PluginHelper;

public abstract class AbstractIssuesReport
extends AbstractRedmineReport
implements IssueCollectorConfiguration {
    protected final String group;

    protected AbstractIssuesReport(String group) {
        super(true, false, false);
        this.group = group;
    }

    protected abstract String getColumnNames();

    protected abstract Map<String, String> getFilters();

    public final String getOutputName() {
        return "redmine-report" + (this.group == null ? "" : "-by-" + this.group);
    }

    @Override
    public final String getName(Locale locale) {
        return this.getBundle(locale).getString("report.name" + (this.group == null ? "" : "-" + this.group));
    }

    @Override
    public final String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.description" + (this.group == null ? "" : "-" + this.group));
    }

    @Override
    protected boolean isRunOnce() {
        return false;
    }

    @Override
    protected boolean checkRunOnceDone() {
        return false;
    }

    @Override
    protected boolean isGoalSkip() {
        return false;
    }

    @Override
    public boolean init() throws Exception {
        this.setVersionId(PluginHelper.removeSnapshotSuffix((String)this.getVersionId()));
        boolean result = super.init();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeReport(Locale locale) throws MavenReportException {
        if (this.isOnlyCurrentVersion()) {
            this.getLog().info((CharSequence)(this.getBundle(locale).getString("report.message.only.for.current.version") + " " + this.getVersionId()));
        }
        String id = this.getProjectId();
        IssuesCollector collector = new IssuesCollector(this.getLog(), this.verbose);
        try {
            collector.collect(this.service, this);
        }
        catch (RedmineServiceException ex) {
            collector.clearFilters();
            throw new MavenReportException("could not obtains issues for reason " + ex.getMessage(), (Exception)((Object)ex));
        }
        Issue[] issues = collector.getIssues();
        try {
            if (issues == null || issues.length == 0) {
                this.getLog().warn((CharSequence)"no issue to treate, will generate an empty raport.");
                IssueReportGenerator reportGenerator = new IssueReportGenerator();
                reportGenerator.doGenerateEmptyReport(this.getBundle(locale), this.getSink());
            } else {
                IssueReportGenerator report = new IssueReportGenerator(this.getLog(), this.getColumnNames(), this.getGroup());
                report.setIssueLinkTemplate(this.getIssueLinkTemplate());
                report.setVersionLinkTemplate(this.getVersionLinkTemplate());
                report.setUrl(this.url.toString());
                report.setIssues(issues);
                report.setUsers(this.service.getUsers(id));
                report.setIssueCategories(this.service.getIssueCategories(id));
                report.setIssueStatuses(this.service.getIssueStatuses());
                report.setIssuePriorities(this.service.getIssuePriorities());
                report.setTrackers(this.service.getTrackers(id));
                report.setVersions(this.service.getVersions(id));
                report.doGenerateReport(this.getBundle(locale), this.getSink(), this.getLog());
            }
        }
        catch (MavenReportException mre) {
            throw mre;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            collector.clearFilters();
        }
    }

    @Override
    public final String getProjectId() {
        return this.projectId;
    }

    @Override
    public final String getVersionId() {
        return this.versionId;
    }

    @Override
    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    @Override
    public String getCategoryIds() {
        return this.getFilters() == null ? null : this.getFilters().get("category");
    }

    @Override
    public String getVersionNames() {
        return this.getFilters() == null ? null : this.getFilters().get("version");
    }

    @Override
    public String getPriorityIds() {
        return this.getFilters() == null ? null : this.getFilters().get("priority");
    }

    @Override
    public String getStatusIds() {
        return this.getFilters() == null ? null : this.getFilters().get("status");
    }

    @Override
    public String getTrackerIds() {
        return this.getFilters() == null ? null : this.getFilters().get("tracker");
    }

    protected final String getGroup() {
        return this.group;
    }

    protected final String getIssueLinkTemplate() {
        return this.issueLinkTemplate;
    }

    protected final String getVersionLinkTemplate() {
        return this.versionLinkTemplate;
    }
}

