/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.table.filter;

import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.runtime.swing.table.filter.FilterTableHeaderRenderer;
import org.nuiton.jaxx.runtime.swing.table.filter.TableFilter;
import org.nuiton.jaxx.runtime.swing.table.filter.TableFilterColumnPopup;

public final class TableRowFilterSupport {
    private boolean searchable = false;
    private Decorator<Object> decorator;
    private final TableFilter<?> filter;
    private boolean actionsVisible = true;
    private boolean useTableRenderers = false;
    private Dimension popupDefaultSize = null;

    private TableRowFilterSupport(TableFilter<?> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filter = filter;
    }

    public static TableRowFilterSupport forFilter(TableFilter<?> filter) {
        return new TableRowFilterSupport(filter);
    }

    public TableRowFilterSupport actions(boolean visible) {
        this.actionsVisible = visible;
        return this;
    }

    public TableRowFilterSupport searchable(boolean searchable) {
        this.searchable = searchable;
        return this;
    }

    public TableRowFilterSupport searchDecorator(Decorator<Object> decorator) {
        this.decorator = decorator;
        return this;
    }

    public TableRowFilterSupport useTableRenderers(boolean value) {
        this.useTableRenderers = value;
        return this;
    }

    public TableRowFilterSupport setPopupDefaultSize(Dimension popupDefaultSize) {
        this.popupDefaultSize = popupDefaultSize;
        return this;
    }

    public JTable apply() {
        TableFilterColumnPopup filterPopup = new TableFilterColumnPopup(this.filter);
        filterPopup.setEnabled(true);
        filterPopup.setActionsVisible(this.actionsVisible);
        filterPopup.setSearchable(this.searchable);
        filterPopup.searchDecorator(this.decorator);
        filterPopup.setUseTableRenderers(this.useTableRenderers);
        filterPopup.setDefaultSize(this.popupDefaultSize);
        this.setupTableHeader();
        return this.filter.getTable();
    }

    private void setupTableHeader() {
        Object table = this.filter.getTable();
        this.filter.addChangeListener(filter -> table.getTableHeader().repaint());
        this.setupHeaderRenderers(((JTable)table).getModel(), true);
    }

    private void setupHeaderRenderers(TableModel newModel, boolean fullSetup) {
        Object table = this.filter.getTable();
        FilterTableHeaderRenderer headerRenderer = new FilterTableHeaderRenderer(this.filter);
        this.filter.modelChanged(newModel);
        for (TableColumn c : Collections.list(((JTable)table).getColumnModel().getColumns())) {
            c.setHeaderRenderer(headerRenderer);
        }
        if (!fullSetup) {
            return;
        }
        PropertyChangeListener listener = e -> this.setupHeaderRenderers(table.getModel(), false);
        ((Container)table).addPropertyChangeListener("model", listener);
        ((Container)table).addPropertyChangeListener("columnModel", listener);
    }
}

