package jaxx.runtime.swing.editor.gis;

/*
 * #%L
 * JAXX :: Widgets
 * $Id: DmsCoordinateEditorModel.java 2756 2013-11-26 14:10:47Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8.7/jaxx-widgets/src/main/java/jaxx/runtime/swing/editor/gis/DmsCoordinateEditorModel.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.io.Serializable;

/**
 * Created on 10/16/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.6
 */
public class DmsCoordinateEditorModel extends DmsCoordinate {

    public static final String PROPERTY_BEAN = "bean";

    public static final String PROPERTY_PROPERTY_SIGN = "propertySign";

    public static final String PROPERTY_PROPERTY_DEGREE = "propertyDegree";

    public static final String PROPERTY_PROPERTY_MINUTE = "propertyMinute";

    public static final String PROPERTY_PROPERTY_SECOND = "propertySecond";

    private static final long serialVersionUID = 1L;

    /** Bean where to push data. */
    protected Serializable bean;

    /** Name of the property of the bean to fire the change of the {@link #sign}. */
    protected String propertySign;

    /** Name of the property of the bean to fire the change of the {@link #degree}. */
    protected String propertyDegree;

    /** Name of the property of the bean to fire the change of the {@link #minute}. */
    protected String propertyMinute;

    /** Name of the property of the bean to fire the change of the {@link #second}. */
    protected String propertySecond;

    public Serializable getBean() {
        return bean;
    }

    public void setBean(Serializable bean) {
        Object oldValue = getBean();
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public String getPropertySign() {
        return propertySign;
    }

    public void setPropertySign(String propertySign) {
        Object oldValue = getPropertySign();
        this.propertySign = propertySign;
        firePropertyChange(PROPERTY_PROPERTY_SIGN, oldValue, propertySign);
    }

    public String getPropertyDegree() {
        return propertyDegree;
    }

    public void setPropertyDegree(String propertyDegree) {
        Object oldValue = getPropertyDegree();
        this.propertyDegree = propertyDegree;
        firePropertyChange(PROPERTY_PROPERTY_DEGREE, oldValue, propertyDegree);
    }

    public String getPropertyMinute() {
        return propertyMinute;
    }

    public void setPropertyMinute(String propertyMinute) {
        Object oldValue = getPropertyMinute();
        this.propertyMinute = propertyMinute;
        firePropertyChange(PROPERTY_PROPERTY_MINUTE, oldValue, propertyMinute);
    }

    public String getPropertySecond() {
        return propertySecond;
    }

    public void setPropertySecond(String propertySecond) {
        Object oldValue = getPropertySecond();
        this.propertySecond = propertySecond;
        firePropertyChange(PROPERTY_PROPERTY_SECOND, oldValue, propertySecond);
    }

    public void setValue(DmsCoordinate value) {
        setSign(value != null && value.isSign());
        setDegree(value == null ? null : value.getDegree());
        setMinute(value == null ? null : value.getMinute());
        setSecond(value == null ? null : value.getSecond());
    }

    public String getStringPattern() {
        return COORDINATE_STRING_PATTERN;
    }
}
