package jaxx.runtime.swing.editor;

/*
 * #%L
 * JAXX :: Widgets
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BaseActionPanel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileEditor extends BaseActionPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACCEPT_ALL_FILE_FILTER_USED = "acceptAllFileFilterUsed";
    public static final String PROPERTY_DIRECTORY_ENABLED = "directoryEnabled";
    public static final String PROPERTY_EXTS = "exts";
    public static final String PROPERTY_EXTS_DESCRIPTION = "extsDescription";
    public static final String PROPERTY_FILE_ENABLED = "fileEnabled";
    public static final String PROPERTY_START_PATH = "startPath";
    public static final String PROPERTY_TITLE = "title";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BOUTON_XSL_LOCATION_ENABLED = "boutonXslLocation.enabled";
    public static final String BINDING_PATH_FIELD_ENABLED = "pathField.enabled";
    public static final String BINDING_PATH_FIELD_TEXT = "pathField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTPW8TQRAdm9jGMZAYixBEkAJJBdIZEAVSEOSDWCEyEBGQItywvlvijdZ3y+4cuTSIn8BPgJ4GiY4KUVBT0CD+AkIUtIjZO9sXh4sSiZPuQzPz3sy+e/P2BxSMhvNbLIocHfooutxZXdjYuN/e4i7e5sbVQmGgIblyeci3oOIN4gZhptW08HoPXl8Kuirwub8LPdeEUYM7kpsO54hwbhjhGlNfH6TnIhXqPutgqCzW179+5l95L9/kASJF01XoKNMHodKTjDQhLzyEk9TpOatL5m/SGFr4mzTvcRtbksyYe6zLn8ELKDWhqJgmMoQLhz9yzBHjI4VQnV1khi+4KAJ/jflcXkaYHRrZbNMADvcEkTgNIfly/KlUTFJEKHWY70muES4dBriSVKf408x1ucIFKW0R3cj1I8NJiKo9s2N1cBaDQHLmp6hxT2hyRKB3ln3Wltyz8Wqarzy1HTNTZYNM4xrDDtGkLRKp07ICCpSx0pNpcIRHaPbExmysrzTpuCddVtSpIbikE03YdlFPmtWHBIwTtrI8AFTbQYiBv2FkM3CZZUSoDQEXQ8SkD6E0nB3SndzrpO5N7ZVrQUGHFEaYbP1r+AeUSqw+ucfqljDO/pmoff3w/X2j72+7qqcyS3etJ/lO6UCRP4RtPZaYO0Qh63eZmmvR7+Ay/pOUncoYbL2XpuGoX+IJC3dWmOkQRaH07eOniSdfjkC+AaMyYF6D2fo7UMaOJhUC6UXq1nw80bHto/Qct7MhFCXbIakRTtzwGLLptvA90vdmRCJMZYgwmKRd/vy7tv5uvi9EjgY7s295KkbhMRSFL4XP41XvbXHmaleU4aEXpNuatb85+x5VPa9djJ9O1klLPN2EK1FoX1fjue3XtZhm+hA0I0iO/V8O4SbW3Ydj5kAOG75+AMNfZ37NNEkGAAA=";
    private static final Log log = LogFactory.getLog(FileEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean acceptAllFileFilterUsed;
    protected JButton boutonXslLocation;
    protected Boolean directoryEnabled;
    protected String exts;
    protected String extsDescription;
    protected Boolean fileEnabled;
    protected FileEditorHandler handler;
    protected JTextField pathField;
    protected String startPath;
    protected String title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FileEditor $BaseActionPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected File selectedFile;
    
    
    public void setSelectedFile(File selectedFile) {
        this.selectedFile = selectedFile;
        if (selectedFile != null) {
            setStartPath(selectedFile.getAbsolutePath());
            fireActionEvent();
        }
    }
    
    public void setSelectedFile(String startPath) {
        this.selectedFile = null;
        setStartPath(startPath);
        fireActionEvent();
    }
    
    public File getSelectedFile() {
        if (selectedFile == null) {
            if (StringUtils.isNotEmpty(startPath)) {
                selectedFile = new File(startPath);
            }
        }
        return selectedFile;
    }
    
    public void setDialogOwner(JDialog dialogOwner) {
      handler.setDialogOwner(dialogOwner);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FileEditor() {
        $initialize();
    }

    public FileEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__boutonXslLocation(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openLocation();
    }

    public void doKeyReleased__on__pathField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedFile(pathField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAcceptAllFileFilterUsed() {
        return acceptAllFileFilterUsed;
    }

    public JButton getBoutonXslLocation() {
        return boutonXslLocation;
    }

    public Boolean getDirectoryEnabled() {
        return directoryEnabled;
    }

    public String getExts() {
        return exts;
    }

    public String getExtsDescription() {
        return extsDescription;
    }

    public Boolean getFileEnabled() {
        return fileEnabled;
    }

    public FileEditorHandler getHandler() {
        return handler;
    }

    public JTextField getPathField() {
        return pathField;
    }

    public String getStartPath() {
        return startPath;
    }

    public String getTitle() {
        return title;
    }

    public Boolean isAcceptAllFileFilterUsed() {
        return acceptAllFileFilterUsed !=null && acceptAllFileFilterUsed;
    }

    public Boolean isDirectoryEnabled() {
        return directoryEnabled !=null && directoryEnabled;
    }

    public Boolean isFileEnabled() {
        return fileEnabled !=null && fileEnabled;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAcceptAllFileFilterUsed(Boolean acceptAllFileFilterUsed) {
        Boolean oldValue = this.acceptAllFileFilterUsed;
        this.acceptAllFileFilterUsed = acceptAllFileFilterUsed;
        firePropertyChange(PROPERTY_ACCEPT_ALL_FILE_FILTER_USED, oldValue, acceptAllFileFilterUsed);
    }

    public void setDirectoryEnabled(Boolean directoryEnabled) {
        Boolean oldValue = this.directoryEnabled;
        this.directoryEnabled = directoryEnabled;
        firePropertyChange(PROPERTY_DIRECTORY_ENABLED, oldValue, directoryEnabled);
    }

    public void setExts(String exts) {
        String oldValue = this.exts;
        this.exts = exts;
        firePropertyChange(PROPERTY_EXTS, oldValue, exts);
    }

    public void setExtsDescription(String extsDescription) {
        String oldValue = this.extsDescription;
        this.extsDescription = extsDescription;
        firePropertyChange(PROPERTY_EXTS_DESCRIPTION, oldValue, extsDescription);
    }

    public void setFileEnabled(Boolean fileEnabled) {
        Boolean oldValue = this.fileEnabled;
        this.fileEnabled = fileEnabled;
        firePropertyChange(PROPERTY_FILE_ENABLED, oldValue, fileEnabled);
    }

    public void setStartPath(String startPath) {
        String oldValue = this.startPath;
        this.startPath = startPath;
        firePropertyChange(PROPERTY_START_PATH, oldValue, startPath);
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        firePropertyChange(PROPERTY_TITLE, oldValue, title);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAcceptAllFileFilterUsed() {
        $objectMap.put("acceptAllFileFilterUsed", acceptAllFileFilterUsed = Boolean.TRUE);
    }

    protected void createBoutonXslLocation() {
        $objectMap.put("boutonXslLocation", boutonXslLocation = new JButton());
        
        boutonXslLocation.setName("boutonXslLocation");
        boutonXslLocation.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__boutonXslLocation"));
    }

    protected void createDirectoryEnabled() {
        $objectMap.put("directoryEnabled", directoryEnabled = Boolean.TRUE);
    }

    protected void createExts() {
        $objectMap.put("exts", exts = null);
    }

    protected void createExtsDescription() {
        $objectMap.put("extsDescription", extsDescription = null);
    }

    protected void createFileEnabled() {
        $objectMap.put("fileEnabled", fileEnabled = Boolean.TRUE);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FileEditorHandler(this));
    }

    protected void createPathField() {
        $objectMap.put("pathField", pathField = new JTextField());
        
        pathField.setName("pathField");
        pathField.setColumns(15);
        pathField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__pathField"));
    }

    protected void createStartPath() {
        $objectMap.put("startPath", startPath = null);
    }

    protected void createTitle() {
        $objectMap.put("title", title = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $BaseActionPanel0
        add(pathField, BorderLayout.CENTER);
        add(boutonXslLocation, BorderLayout.EAST);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        boutonXslLocation.setIcon(SwingUtil.createActionIcon("open"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$BaseActionPanel0", $BaseActionPanel0);
        createHandler();
        createAcceptAllFileFilterUsed();
        createDirectoryEnabled();
        createFileEnabled();
        createStartPath();
        createTitle();
        createExts();
        createExtsDescription();
        createPathField();
        createBoutonXslLocation();
        // inline creation of $BaseActionPanel0
        setName("$BaseActionPanel0");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PATH_FIELD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                pathField.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PATH_FIELD_TEXT, true ,"startPath") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText(pathField, getStartPath());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BOUTON_XSL_LOCATION_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                boutonXslLocation.setEnabled(isEnabled());
            }
        });
    }

}