/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis.absolute;

import com.google.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import jaxx.runtime.spi.UIHandler;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.gis.DdCoordinate;
import org.nuiton.jaxx.widgets.gis.DdCoordinateConverter;
import org.nuiton.jaxx.widgets.gis.MaskFormatterFromConverter;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDdCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDdCoordinateEditorModel;
import org.nuiton.util.beans.BeanUtil;

public class AbsoluteDdCoordinateEditorHandler
implements UIHandler<AbsoluteDdCoordinateEditor> {
    private static final Log log = LogFactory.getLog(AbsoluteDdCoordinateEditorHandler.class);
    private AbsoluteDdCoordinateEditor ui;
    protected Method degreeMutator;
    protected Method decimalMutator;
    protected boolean valueIsAdjusting;
    protected boolean valueModelIsAdjusting;
    protected DdCoordinateConverter coordinateConverter;

    public void beforeInit(AbsoluteDdCoordinateEditor ui) {
        this.ui = ui;
        this.coordinateConverter = new DdCoordinateConverter();
    }

    public void afterInit(AbsoluteDdCoordinateEditor ui) {
    }

    public void init(boolean longitudeEditor) {
        MaskFormatterFromConverter<DdCoordinate> maskFormatter;
        final AbsoluteDdCoordinateEditorModel model = this.ui.getModel();
        Preconditions.checkNotNull((Object)model.getBean(), (Object)("could not find bean in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyDegree(), (Object)("could not find propertyDegree in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyDecimal(), (Object)("could not find propertyDecimal in " + this.ui));
        Serializable bean = model.getBean();
        this.degreeMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyDegree());
        Preconditions.checkNotNull((Object)this.degreeMutator, (Object)("could not find mutator for " + model.getPropertyDegree()));
        this.decimalMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyDecimal());
        Preconditions.checkNotNull((Object)this.decimalMutator, (Object)("could not find mutator for " + model.getPropertyDecimal()));
        this.coordinateConverter.setForLongitude(longitudeEditor);
        String pattern = this.getMaskFormatterPattern(longitudeEditor);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DdCoordinate.class, pattern, (Converter)this.coordinateConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        JFormattedTextField editor = this.ui.getEditor();
        DefaultFormatterFactory formatterFactory = new DefaultFormatterFactory(maskFormatter);
        editor.setFormatterFactory(formatterFactory);
        editor.setFocusLostBehavior(0);
        editor.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DdCoordinate newValue = (DdCoordinate)((Object)evt.getNewValue());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Value has changed: " + (Object)((Object)newValue)));
                }
                model.setValue(newValue);
            }
        });
        model.addPropertyChangeListener("degree", new ModelPropertyChangeListener(model, this.degreeMutator));
        model.addPropertyChangeListener("decimal", new ModelPropertyChangeListener(model, this.decimalMutator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(DdCoordinate value, boolean pushToModel) {
        if (this.valueModelIsAdjusting) {
            return;
        }
        this.valueIsAdjusting = !pushToModel;
        try {
            this.ui.getEditor().setValue((Object)value);
        }
        finally {
            this.valueIsAdjusting = false;
        }
    }

    public void resetEditor() {
        this.setValue(null, true);
    }

    protected String getMaskFormatterPattern(boolean longitudeEditor) {
        String pattern = "**.***";
        if (longitudeEditor) {
            pattern = "*" + pattern;
        }
        return pattern;
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final AbsoluteDdCoordinateEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(AbsoluteDdCoordinateEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!AbsoluteDdCoordinateEditorHandler.this.valueIsAdjusting) {
                Object newValue = evt.getNewValue();
                try {
                    AbsoluteDdCoordinateEditorHandler.this.valueModelIsAdjusting = true;
                    try {
                        this.mutator.invoke((Object)this.model.getBean(), newValue);
                    }
                    finally {
                        AbsoluteDdCoordinateEditorHandler.this.valueModelIsAdjusting = false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

