package org.nuiton.jaxx.widgets.datetime;

/*
 * #%L
 * JAXX :: Widgets DateTime
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n.t;

public class DateTimeEditor extends JPanel implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DAY_DATE_EDITOR_DATE = "dayDateEditor.date";
    public static final String BINDING_DAY_DATE_EDITOR_ENABLED = "dayDateEditor.enabled";
    public static final String BINDING_HOUR_EDITOR_ENABLED = "hourEditor.enabled";
    public static final String BINDING_HOUR_MODEL_VALUE = "hourModel.value";
    public static final String BINDING_MINUTE_EDITOR_ENABLED = "minuteEditor.enabled";
    public static final String BINDING_MINUTE_MODEL_VALUE = "minuteModel.value";
    public static final String BINDING_SLIDER_ENABLED = "slider.enabled";
    public static final String BINDING_SLIDER_VALUE = "slider.value";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRQeu7UT23GakBJSSCUTEEqhrJ22KofwoyGO5UR2U8VpFfChjL0Te9L17DI722xqFfEf0D8B7lyQuHFCHDhz4IL4FxDiwBX1zewvr7OtEwkfJrsz733ve+/N+zbf/4UyNkdvHmHX1bjDBB0QbWfj4GC3c0S6okrsLqeWMDnyfqk0SrdRQQ/3bYHeajeke9l3L2+aA8tkhI14rzdQ3hYnBrH7hAiBrsY9urZdboXH667l8AA1JJWE+u0/f6ef6V9/l0bItYDdLKRSmuQVZXKxgdJUF+gViPQYlw3MekCDU9YDvkW5t2lg276LB+RL9BWaaqCshTmACbRy9pQVhvJ3LYGm3965hxkxKgKVTd7TmEOFyTRF+pjqPSJsTceCKPZVeNiHhy0djLhlKZisQJmBqRNDoFvnRGhKtwgm1zcdb0+gZZmuq9nHkL3WsihjhEvnMZfCgDLH35Vb8yNoj7FBIbDJBXov1oTwIICX64NgM0LIS9oeU2jKKCGvZtIsF1oXdT+3Bu7IDOIOalNavhY6BKVfk+9X4mcAdlIdiV6SlT2Ca/5ImJaH6Wo7B9LkHu0+Ilz6XQ3dZ2WekX8YILLIy1oH6JdjVP1qS8OV0D5ryATq8m05fjLjtSCK9M6Ypw2FJRBlIR5F7fol5OiNWIdgALVoAKMJSbVRhjuwLdBS+/TM7sGRN61LY9MqAdXpf4sLv//054+1YETzEPvVRNMRhYHRsbhpQRJUhr7kzacjqFFuYmu9jXI2MUCelPwsJxBr+cdADuLNS3dNumt1bPcBIjP1x8+/LH7x2wWUrqG8YWK9hqX9NsqJPocqmIbuWp/cUYxmjqdhnZPcoKh9k9MnJhPY2DBojw2UHGS78IdwFyqxnFCJkE4n9+u/C60f7gTVSAG7Ky80jyqS+RxlKTMoI0qyfDVKlKiCZRNHNyPVSdIhBBoiqDCI5U/fTbV+cCrjCwJNEYY7BgGdLA6pveW9rF57KtBFJTPo8lDJkQbKU/WmSJ1OHZp8gAV0aHa4ouvlZrN8Ar+Vp64jY62r9OXTR2h8/iaxSgN9EBUHgleGfcx0g3AZvh7o2QN5uBrS2venc/WaJFbsYoMwHfMaJQaktTjc9De0+u79vYe7tYfVjc8SaUaKeQaKLy5coN+FYYiXGG5ENM4Q76VXE7oliAvvM/KaEYWp1ZOC+spzjh7cGO1BM/pAnKsL81EXmtt37+9vJVZk9Pvzv7SgOBxBTAwZ09tJMacFmhvgI5Pvw1eiZeEuaK9A6duVl3HJW5gyIT1s2SYuaxrwqwwZOS5VySF2DPGp6TCd6Hvwj4pHeLVyvbR2vQTr7Urp3dKNWxKuoODUBzDCm4MsxlndBFa5Q7gw79v0Cdik19aipr4+jDVum3mNtYFx4q3xvjqT6pNS9+vEdOAmzn4I+oFLHcp04PPxKdSUXPMTEeX2N3J5loywBAjPAZobA13nCgAA";
    private static final Log log = LogFactory.getLog(DateTimeEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "date",  editorName = "dateEditor")
    protected JPanel dateEditor;
    protected JLabel dateTimeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "dayDate",  editorName = "dayDateEditor")
    protected JXDatePicker dayDateEditor;
    protected final DateTimeEditorHandler handler = new DateTimeEditorHandler();
    protected JSpinner hourEditor;
    protected SpinnerDateModel hourModel;
    protected JLabel labelH;
    protected JSpinner minuteEditor;
    protected SpinnerDateModel minuteModel;
    protected DateTimeEditorModel model;
    protected JSlider slider;
    @ValidatorField( validatorId = "validator",  propertyName = "timeDate",  editorName = "timeDateEditor")
    protected JPanel timeDateEditor;
    @Validator( validatorId = "validator")
    protected SwingValidator<DateTimeEditorModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DateTimeEditor $JPanel0 = this;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    
    public void setBean(Serializable bean) { model.setBean(bean); }
    public void setPropertyTimeDate(String property) { model.setPropertyTimeDate(property); }
    public void setPropertyDayDate(String property) { model.setPropertyDayDate(property); }
    public void setPropertyDate(String property) { model.setPropertyDate(property); }
    public void setDate(Date date) { model.setDate(date); }
    
    public void setDateFormat(String dateFormat) { dayDateEditor.setFormats(dateFormat); }
    public void setLabel(String label) { dateTimeLabel.setText(label); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateTimeEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateTimeEditor() {
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateTimeEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DateTimeEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__dayDateEditor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setDayDate((Date)((JXDatePicker)event.getSource()).getDate());
    }

    public void doStateChanged__on__hourEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setHours((Date)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__minuteEditor(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setMinutes((Date)((JSpinner)event.getSource()).getValue());
    }

    public void doStateChanged__on__slider(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (!slider.getValueIsAdjusting()) model.setTimeInMinutes((Integer)((JSlider)event.getSource()).getValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getDateEditor() {
        return dateEditor;
    }

    public JLabel getDateTimeLabel() {
        return dateTimeLabel;
    }

    public JXDatePicker getDayDateEditor() {
        return dayDateEditor;
    }

    public DateTimeEditorHandler getHandler() {
        return handler;
    }

    public JSpinner getHourEditor() {
        return hourEditor;
    }

    public SpinnerDateModel getHourModel() {
        return hourModel;
    }

    public JLabel getLabelH() {
        return labelH;
    }

    public JSpinner getMinuteEditor() {
        return minuteEditor;
    }

    public SpinnerDateModel getMinuteModel() {
        return minuteModel;
    }

    public DateTimeEditorModel getModel() {
        return model;
    }

    public JSlider getSlider() {
        return slider;
    }

    public JPanel getTimeDateEditor() {
        return timeDateEditor;
    }

    public SwingValidator<DateTimeEditorModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDateEditor() {
        if (!allComponentsCreated) {
            return;
        }
        dateEditor.add(dateTimeLabel, BorderLayout.WEST);
        dateEditor.add($JPanel1, BorderLayout.EAST);
    }

    protected void addChildrenToTimeDateEditor() {
        if (!allComponentsCreated) {
            return;
        }
        timeDateEditor.add(hourEditor);
        timeDateEditor.add(labelH);
        timeDateEditor.add(minuteEditor);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setBean(model);
    }

    protected void createDateEditor() {
        $objectMap.put("dateEditor", dateEditor = new JPanel());
        
        dateEditor.setName("dateEditor");
        dateEditor.setLayout(new BorderLayout());
    }

    protected void createDateTimeLabel() {
        $objectMap.put("dateTimeLabel", dateTimeLabel = new JLabel());
        
        dateTimeLabel.setName("dateTimeLabel");
    }

    protected void createDayDateEditor() {
        $objectMap.put("dayDateEditor", dayDateEditor = new JXDatePicker());
        
        dayDateEditor.setName("dayDateEditor");
        dayDateEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dayDateEditor"));
    }

    protected void createHourEditor() {
        $objectMap.put("hourEditor", hourEditor = new JSpinner());
        
        hourEditor.setName("hourEditor");
        hourEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__hourEditor"));
    }

    protected void createHourModel() {
        $objectMap.put("hourModel", hourModel = new SpinnerDateModel());
    }

    protected void createLabelH() {
        $objectMap.put("labelH", labelH = new JLabel());
        
        labelH.setName("labelH");
        labelH.setHorizontalAlignment(0);
        labelH.setText(t("timeeditor.H"));
    }

    protected void createMinuteEditor() {
        $objectMap.put("minuteEditor", minuteEditor = new JSpinner());
        
        minuteEditor.setName("minuteEditor");
        minuteEditor.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__minuteEditor"));
    }

    protected void createMinuteModel() {
        $objectMap.put("minuteModel", minuteModel = new SpinnerDateModel());
    }

    protected void createModel() {
        $objectMap.put("model", model = new DateTimeEditorModel());
    }

    protected void createSlider() {
        $objectMap.put("slider", slider = new JSlider());
        
        slider.setName("slider");
        slider.setValue(0);
        slider.setMajorTickSpacing(60);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setMinorTickSpacing(30);
        if (slider.getFont() != null) {
            slider.setFont(slider.getFont().deriveFont((float) 11));
        }
        slider.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__slider"));
    }

    protected void createTimeDateEditor() {
        $objectMap.put("timeDateEditor", timeDateEditor = new JPanel());
        
        timeDateEditor.setName("timeDateEditor");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(DateTimeEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(SwingUtil.boxComponentWithJxLayer(dateEditor), BorderLayout.NORTH);
        add(slider, BorderLayout.SOUTH);
        addChildrenToValidator();
        addChildrenToDateEditor();
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(dayDateEditor));
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(timeDateEditor));
        addChildrenToTimeDateEditor();
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        hourModel.setCalendarField(Calendar.HOUR_OF_DAY);
        minuteModel.setCalendarField(Calendar.MINUTE);
        dayDateEditor.setFormats("dd/MM/yyyy");
        hourEditor.setModel(hourModel);
        minuteEditor.setModel(minuteModel);
        slider.setModel(new DefaultBoundedRangeModel(0, 1, 0, 60 * 24));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createHourModel();
        createMinuteModel();
        createValidator();
        createDateEditor();
        createDateTimeLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createDayDateEditor();
        createTimeDateEditor();
        createHourEditor();
        createLabelH();
        createMinuteEditor();
        createSlider();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HOUR_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    hourModel.setValue(handler.getHourModelValue(model.getTimeDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MINUTE_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minuteModel.setValue(handler.getMinuteModelValue(model.getTimeDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeDate", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DAY_DATE_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                dayDateEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DAY_DATE_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dayDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dayDateEditor.setDate(model.getDayDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dayDate", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HOUR_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                hourEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MINUTE_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                minuteEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                slider.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SLIDER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeInMinutes", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    slider.setValue(model.getTimeInMinutes());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeInMinutes", this);
                }
            }
        });
    }

}