/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.validator.swing.SwingListValidatorDataLocator;
import org.nuiton.validator.bean.list.BeanListValidator;

public class SwingListValidatorTableEditorModelListener<O>
implements TableModelListener {
    private static final Log log = LogFactory.getLog(SwingListValidatorTableEditorModelListener.class);
    private final SwingListValidatorDataLocator<O> dataLocator;
    private final BeanListValidator<O> validator;

    public SwingListValidatorTableEditorModelListener(BeanListValidator<O> validator, SwingListValidatorDataLocator<O> dataLocator) {
        this.dataLocator = dataLocator;
        this.validator = validator;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        TableModel model = (TableModel)e.getSource();
        int type = e.getType();
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        switch (type) {
            case 1: {
                this.onRowsInserted(model, firstRow, lastRow);
                break;
            }
            case -1: {
                this.onRowsDeleted(model);
                break;
            }
            case 0: {
                if (e.getColumn() != -1 || firstRow != 0 || lastRow != Integer.MAX_VALUE) break;
                this.onDataChanged(model);
            }
        }
    }

    protected void onRowsInserted(TableModel model, int firstRow, int lastRow) {
        HashSet beans = Sets.newHashSet();
        for (int i = firstRow; i <= lastRow; ++i) {
            O bean = this.dataLocator.locateBean(model, i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add a bean to validator " + bean));
            }
            beans.add(bean);
        }
        this.validator.addAllBeans((Collection)beans);
    }

    protected void onRowsDeleted(TableModel model) {
        HashSet beans = Sets.newHashSet((Iterable)this.validator.getBeans());
        int max = model.getRowCount();
        for (int i = 0; i < max; ++i) {
            O bean = this.dataLocator.locateBean(model, i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove a bean from validator " + bean));
            }
            beans.remove(bean);
        }
        this.validator.removeAllBeans((Collection)beans);
    }

    protected void onDataChanged(TableModel model) {
        this.validator.removeAllBeans();
        HashSet beans = Sets.newHashSet();
        int max = model.getRowCount();
        for (int i = 0; i < max; ++i) {
            O bean = this.dataLocator.locateBean(model, i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add a bean to validator " + bean));
            }
            beans.add(bean);
        }
        this.validator.addAllBeans((Collection)beans);
    }
}

