/*
 * *##% 
 * JAXX Action
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
/* 
* \#\#% Copyright (C) 2002, 2003, 2004, 2005, 2006, 2007, 2008 Code Lutin,
* Tony Chemit
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
* \#\#% */
package org.nuiton.jaxx.tab;

import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.JAXXTab;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import java.awt.Component;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/**
 * Une usine pour les Tabs, leur configs et leur modèles
 *
 * @author tony
 * @see TabContentConfig
 * @see TabModel
 */

public abstract class TabFactory {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    protected static Log log = LogFactory.getLog(TabFactory.class);

    /** dictionary of configs */
    protected Map<String, TabContentConfig> configs;

    /** dictionary of instanciated actions */
    protected Map<String, JAXXTab> cache;

    /** dictionary of instanciated models */
    protected Map<String, TabModel> models;

    protected abstract Map<String, TabContentConfig> initFactory();

    protected abstract void initTab(JAXXTab tab, String tabName, TabContentConfig config);

    protected JAXXTab newTab(String tabName) {

        checkRegistredConfig(tabName);

        // try in cache
        if (cache.containsKey(tabName)) {
            // use cached tab
            return cache.get(tabName);
        }

        TabContentConfig config = configs.get(tabName);

        JAXXTab instance;
        try {
            instance = config.impl().newInstance();
            if (log.isDebugEnabled()) {
                log.debug("new tab       : " + instance);
            }

            cache.put(tabName, instance);

            initJAXXTab(config, instance);
            initTab(instance, tabName, config);

            return instance;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> keySet() {
        return cache.keySet();
    }

    public TabContentConfig getConfig(String tabName) {
        checkRegistredConfig(tabName);
        return configs.get(tabName);
    }

    public JAXXTab getUI(String tabName) {
        return cache.get(tabName);
    }

    public TabModel getModel(String tabName, Object... params) {

        if (models.containsKey(tabName)) {
            return models.get(tabName);
        }
        TabContentConfig config = getConfig(tabName);
        TabModel tabModel;
        try {
            tabModel = initTabModel(config, params);
            if (log.isDebugEnabled()) {
                log.debug("new tab model : " + tabModel);
            }
            models.put(tabName, tabModel);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tabModel;
    }

    protected TabModel initTabModel(TabContentConfig config, Object... params) throws InstantiationException, IllegalAccessException {
        TabModel tabModel;
        tabModel = config.model().newInstance();
        return tabModel;
    }

    public void showTab(final JTabbedPane container, String tabName) {

        TabContentConfig config = getConfig(tabName);

        JAXXTab comp = newTab(tabName);

        int index = getTabIndex(container, comp);
        if (index == -1) {
            registerTab(container, tabName, config, comp);
        }

        container.setSelectedComponent(comp);
    }

    public void closeTab(JTabbedPane container, String tabName) {

        TabContentConfig config = getConfig(tabName);

        final JComponent comp = cache.get(tabName);

        int index = getTabIndex(container, comp);
        if (index != -1) {
            container.removeTabAt(index);
            if (log.isDebugEnabled()) {
                log.debug(config + " index " + index);
            }
        }
    }

    public int getTabIndex(final JTabbedPane container, JComponent comp) {
        if (container != null && comp != null) {
            for (int i = 0; i < container.getTabCount(); i++) {
                Component o = container.getComponentAt(i);
                if (o.equals(comp)) {
                    return i;
                }
            }
        }
        return -1;
    }

    public void resetCache() {
        cache.clear();
        models.clear();
    }


    protected TabFactory() {
        configs = initFactory();
        cache = new TreeMap<String, JAXXTab>();
        models = new TreeMap<String, TabModel>();
    }

    protected JComponent addTabHeader(final JTabbedPane container, final String tabName, final TabContentConfig config, final JAXXTab comp) {
        // by default, no tab header
        return null;
    }

    protected void registerTab(final JTabbedPane container, final String tabName, final TabContentConfig config, final JAXXTab comp) {

        container.addTab(tabName, comp);

        JComponent header = addTabHeader(container, tabName, config, comp);

        if (header != null) {

            container.setTabComponentAt(container.getTabCount() - 1, header);
        }
    }

    @SuppressWarnings({"unchecked"})
    protected void initJAXXTab(TabContentConfig config, JAXXTab instance) throws NoSuchFieldException, IllegalAccessException {
        if (instance instanceof JAXXObject) {
            JAXXObject ui = (JAXXObject) instance;
            for (String dynamicField : config.dynamicFields()) {
                String dynamciName = dynamicField + '_' + config.name();
                Object obj = ui.getObjectById(dynamicField);
                Field m = ui.getClass().getDeclaredField("$objectMap");
                m.setAccessible(true);
                Map<Object, Object> map = (Map<Object, Object>) m.get(ui);
                map.put(dynamciName, obj);
            }
        }
    }

    protected void checkRegistredConfig(String tabName) {
        if (!configs.containsKey(tabName)) {
            throw new IllegalStateException("can not find a registered TabContentConfig for tab name  " + tabName);
        }
    }

}