/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.nav;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.swing.nav.NavBridge;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.NavNodeChildLoador;
import jaxx.runtime.swing.nav.tree.AbstractNavTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NavHelper<M, U, B extends NavBridge<M, N>, N extends NavNode<M, N>> {
    private static final Log log = LogFactory.getLog(NavHelper.class);
    private final B bridge;
    private U ui;
    protected NavDataProvider dataProvider;
    protected TreeWillExpandListener expandListener;
    protected TreeSelectionListener selectionListener;
    protected TreeModelListener treeModelListener;
    protected static Set<? super NavNodeChildLoador<?, ?, ?, ?, ?>> childLoadors;

    public abstract void scrollPathToVisible(TreePath var1);

    public abstract void setSelectionPath(TreePath var1);

    public abstract void addSelectionPath(TreePath var1);

    public abstract void addSelectionPaths(TreePath[] var1);

    public abstract void removeSelectionPath(TreePath var1);

    public abstract void removeSelectionPaths(TreePath[] var1);

    public abstract TreeSelectionModel getSelectionModel();

    public abstract boolean isExpanded(TreePath var1);

    public abstract void expandPath(TreePath var1);

    protected abstract M createModel(N var1, Object ... var2);

    public abstract AbstractNavTreeCellRenderer<M, N> getTreeCellRenderer();

    public abstract N getSelectedNode();

    public abstract List<N> getSelectedNodes();

    public abstract void setUI(U var1, boolean var2, boolean var3, TreeSelectionListener var4, TreeWillExpandListener var5);

    protected static Set<? super NavNodeChildLoador<?, ?, ?, ?, ?>> getChildLoadors() {
        if (childLoadors == null) {
            childLoadors = new HashSet();
        }
        return childLoadors;
    }

    public static <L extends NavNodeChildLoador<?, ?, ?, ?, ?>> L getChildLoador(Class<L> type) {
        Set<NavNodeChildLoador<?, ?, ?, ?, ?>> cache = NavHelper.getChildLoadors();
        NavNodeChildLoador<?, ?, ?, ?, ?> result = null;
        for (NavNodeChildLoador<?, ?, ?, ?, ?> loador : cache) {
            if (!type.equals(loador.getClass())) continue;
            result = loador;
            break;
        }
        if (result == null) {
            try {
                result = (NavNodeChildLoador<?, ?, ?, ?, ?>)type.newInstance();
                cache.add(result);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add " + result + " in loadors cache (new size:" + cache.size() + ")."));
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not instanciate loador [" + type.getName() + "]", e);
            }
        }
        return (L)result;
    }

    public NavHelper(B bridge) {
        this.bridge = bridge;
        this.selectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!NavHelper.this.checkModel()) {
                    return;
                }
                TreeSelectionModel source = NavHelper.this.getSelectionModel();
                if (source.isSelectionEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Selection is empty.");
                    }
                    return;
                }
                boolean debugEnabled = log.isDebugEnabled();
                boolean traceEnabled = log.isTraceEnabled();
                for (TreePath path : e.getPaths()) {
                    Object node = NavHelper.this.getNode(path);
                    if (node == null) {
                        if (!debugEnabled) continue;
                        log.debug((Object)"Skip for null node.");
                        continue;
                    }
                    boolean isAdded = e.isAddedPath(path);
                    TreePath pathToExpand = new TreePath(NavHelper.this.bridge.getPathToRoot((TreeNode)node));
                    boolean pathExpanded = NavHelper.this.isExpanded(pathToExpand);
                    if (traceEnabled || isAdded && debugEnabled) {
                        log.debug((Object)"==== Node selection ====================================");
                        log.debug((Object)("node             ? " + node));
                        log.debug((Object)("is added         ? " + isAdded));
                        log.debug((Object)("is path expanded ? " + pathExpanded));
                        log.debug((Object)("is node static   ? " + node.isStaticNode()));
                        log.debug((Object)("is node loaded   ? " + node.isLoaded()));
                        log.debug((Object)("is node leaf     ? " + node.isLeaf()));
                        log.debug((Object)("node nb childs   ? " + node.getChildCount()));
                    }
                    if (!isAdded || pathExpanded) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("expand node [" + pathToExpand + "]"));
                    }
                    NavHelper.this.expandPath(pathToExpand);
                }
            }
        };
        this.expandListener = new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                if (!NavHelper.this.checkModel()) {
                    return;
                }
                Object source = NavHelper.this.getNode(event.getPath());
                if (source.isLoaded()) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("will load childs of node [" + source + "]"));
                }
                source.populateChilds(NavHelper.this.getBridge(), NavHelper.this.getDataProvider());
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
            }
        };
        this.treeModelListener = new TreeModelListener(){

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                if (!NavHelper.this.checkModel()) {
                    return;
                }
                Object source = NavHelper.this.getNode(e.getTreePath());
                Object[] children = e.getChildren();
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.getMessage("inserted         ", source, children));
                }
                NavHelper.this.populateNode(null, children, false);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                if (!NavHelper.this.checkModel()) {
                    return;
                }
                Object source = NavHelper.this.getNode(e.getTreePath());
                Object[] children = e.getChildren();
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.getMessage("removed          ", source, children));
                }
                AbstractNavTreeCellRenderer renderer = NavHelper.this.getTreeCellRenderer();
                if (children != null && renderer != null) {
                    for (Object child : children) {
                        renderer.invalidateCache((NavNode)child);
                    }
                }
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                if (!NavHelper.this.checkModel()) {
                    return;
                }
                Object source = NavHelper.this.getNode(e.getTreePath());
                Object[] children = e.getChildren();
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.getMessage("changed          ", source, children));
                }
                NavHelper.this.populateNode(null, children, false);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                if (!NavHelper.this.checkModel()) {
                    return;
                }
                Object source = NavHelper.this.getNode(e.getTreePath());
                Object[] children = e.getChildren();
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.getMessage("structure changed", source, children));
                }
                NavHelper.this.populateNode(source, children, true);
            }

            protected String getMessage(String action, N source, Object[] children) {
                StringBuilder sb = new StringBuilder();
                sb.append("==== Nodes ");
                sb.append(action);
                sb.append(" =================");
                sb.append("\nsource   : ").append(source);
                sb.append("\nnb nodes : ");
                sb.append(children == null ? 0 : children.length);
                if (children != null) {
                    int i = 0;
                    for (Object child : children) {
                        sb.append("\n [");
                        sb.append(i++);
                        sb.append("] - ");
                        sb.append(child);
                    }
                }
                return sb.toString();
            }
        };
    }

    protected NavDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public M getModel() {
        return this.bridge.getModel();
    }

    protected B getBridge() {
        return this.bridge;
    }

    public U getUI() {
        return this.ui;
    }

    public N getRootNode() {
        if (!this.checkModel()) {
            return null;
        }
        return this.bridge.getRoot();
    }

    public String[] getSelectedIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (N selectedNode = this.getSelectedNode(); selectedNode != null && !selectedNode.isRoot(); selectedNode = selectedNode.getParent()) {
            result.add(selectedNode.getId());
        }
        Collections.reverse(result);
        return result.toArray(new String[result.size()]);
    }

    public void setUI(U tree, boolean addExpandTreeListener) {
        this.setUI(tree, addExpandTreeListener, null);
    }

    public void setUI(U tree, boolean addExpandTreeListener, TreeSelectionListener listener) {
        this.setUI(tree, addExpandTreeListener, true, listener);
    }

    public void setUI(U tree, boolean addExpandTreeListener, boolean addOneClickSelectionListener, TreeSelectionListener listener) {
        this.setUI(tree, addExpandTreeListener, addOneClickSelectionListener, listener, null);
    }

    public void setDataProvider(NavDataProvider dataProvider) {
        this.dataProvider = dataProvider;
        AbstractNavTreeCellRenderer<M, N> renderer = this.getTreeCellRenderer();
        if (renderer != null) {
            renderer.setDataProvider(dataProvider);
        }
    }

    public void insertNode(N parentNode, N newNode) {
        parentNode.add(newNode);
        this.bridge.notifyNodeInserted(newNode);
    }

    public void insertNode(N parentNode, N newNode, int position) {
        parentNode.insert(newNode, position);
        this.bridge.notifyNodeInserted(newNode);
    }

    public N removeNode(N node) {
        Object parentNode = node.getParent();
        this.bridge.removeNodeFromParent(node);
        return parentNode;
    }

    public void moveNode(N parentNode, N node, int position) {
        parentNode.remove(node);
        parentNode.insert(node, position);
        this.bridge.nodeStructureChanged((TreeNode)parentNode);
    }

    public void refreshNode(N node, boolean deep) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will refresh (deep ? " + deep + ") node " + node));
        }
        this.bridge.nodeChanged((TreeNode)node);
        if (deep) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                NavNode child = (NavNode)e.nextElement();
                this.refreshNode(child, true);
            }
        }
    }

    public void loadAllNodes(N node, NavDataProvider dataProvider) {
        if (!this.checkModel()) {
            return;
        }
        if (!node.isLoaded()) {
            node.populateChilds(this.getBridge(), dataProvider);
            Enumeration<? extends TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                NavNode jaxxNode = (NavNode)enumeration.nextElement();
                this.loadAllNodes(jaxxNode, dataProvider);
            }
        }
    }

    public void selectParentNode() throws NullPointerException {
        N node = this.getSelectedNode();
        if (node == null) {
            throw new NullPointerException("no selected node in context");
        }
        node = node.getParent();
        this.selectNode(node);
    }

    public void selectNode(N node) {
        if (!this.checkModel()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("try to select node [" + node + "]"));
        }
        TreePath path = new TreePath(this.bridge.getPathToRoot((TreeNode)node));
        this.addSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public void selectNodes(List<N> nodes) {
        if (!this.checkModel()) {
            return;
        }
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (NavNode node : nodes) {
            paths.add(new TreePath(this.bridge.getPathToRoot(node)));
        }
        this.addSelectionPaths(paths.toArray(new TreePath[paths.size()]));
    }

    public void unSelectNode(N node) {
        if (!this.checkModel()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("try to select node [" + node + "]"));
        }
        TreePath path = new TreePath(this.bridge.getPathToRoot((TreeNode)node));
        this.removeSelectionPath(path);
    }

    public void unSelectNodes(List<N> nodes) {
        if (!this.checkModel()) {
            return;
        }
        for (NavNode node : nodes) {
            this.unSelectNode(node);
        }
    }

    public void selectNode(String ... path) {
        if (!this.checkModel()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("try to select node from ids " + Arrays.toString(path)));
        }
        Object root = this.bridge.getRoot();
        Object node = this.findNode(root, path);
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected node [" + node + "]"));
        }
        if (node != null) {
            this.selectNode(node);
        }
    }

    public N findNode(N node, String ... ids) {
        String id;
        if (!this.checkModel()) {
            return null;
        }
        N result = null;
        String[] stringArray = ids;
        int n = stringArray.length;
        for (int i = 0; i < n && (result = (N)node.findNodeById(id = stringArray[i], this.getBridge(), this.getDataProvider())) != null; ++i) {
            node = result;
        }
        return result;
    }

    public N getChild(N node, String id) {
        if (!this.checkModel()) {
            return null;
        }
        return node.getChild(id, this.getBridge(), this.getDataProvider());
    }

    protected boolean checkModel() {
        if (this.getModel() == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No model set in " + this));
            }
            return false;
        }
        return true;
    }

    protected void populateNode(N node, Object[] children, boolean recurse) {
        NavDataProvider dataProvider = this.getDataProvider();
        if (node != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will populate node : " + node));
            }
            node.populateNode(this.getBridge(), dataProvider, false);
        }
        if (children != null) {
            for (Object o : children) {
                NavNode child = (NavNode)o;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will populate child node : " + child));
                }
                child.populateNode(this.getBridge(), dataProvider, recurse);
            }
        }
    }

    protected N getNode(TreePath path) {
        return (N)((NavNode)path.getLastPathComponent());
    }

    protected void setUI(U ui) {
        this.ui = ui;
    }
}

