/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.decorator;

import java.util.Map;
import java.util.TreeMap;
import jaxx.runtime.decorator.JXPathContextTester;
import jaxx.runtime.decorator.MapPropertyHandler;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MapPropertyHandlerTest
extends JXPathContextTester {
    private static final Log log = LogFactory.getLog(MapPropertyHandlerTest.class);
    private static final String TWO_ID = "two";
    private static final String ONE_ID = "one";

    @BeforeClass
    public static void beforeClass() {
        JXPathIntrospector.registerDynamicClass(Map.class, MapPropertyHandler.class);
    }

    @Before
    public void setUp() {
        TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
        map.put(ONE_ID, true);
        map.put(TWO_ID, false);
        if (log.isInfoEnabled()) {
            log.info((Object)("init map : " + map));
        }
        this.newContext(map);
    }

    @Test
    public void testValues() throws Exception {
        Boolean value = (Boolean)this.getValue(".[@name='one']");
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)value);
        value = (Boolean)this.getValue(".[@name='two']");
        Assert.assertNotNull((Object)value);
        Assert.assertFalse((boolean)value);
        value = (Boolean)this.getValue(".[@name='three']");
        Assert.assertNull((Object)value);
    }

    @Test
    public void testKey() throws Exception {
        String key = (String)this.getValue(".[@name='key:one']");
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)ONE_ID, (Object)key);
        key = (String)this.getValue(".[@name='key:two']");
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)TWO_ID, (Object)key);
        key = (String)this.getValue(".[@name='key:fake']");
        Assert.assertNull((Object)key);
    }

    @Test
    public void testValue() throws Exception {
        Boolean value = (Boolean)this.getValue(".[@name='value:true']");
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)value);
        value = (Boolean)this.getValue(".[@name='value:false']");
        Assert.assertNotNull((Object)value);
        Assert.assertFalse((boolean)value);
        value = (Boolean)this.getValue(".[@name='value:fake']");
        Assert.assertNull((Object)value);
    }
}

