/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.swing.navigation.NavigationTreeTableNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.tree.TreeModelSupport;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class NavigationTreeTableModel
extends DefaultTreeTableModel
implements NavigationModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NavigationTreeTableModel.class);
    protected final String pathSeparator;
    private JAXXContext context;
    protected List<String> columnsName;

    public NavigationTreeTableModel(String pathSeparator, JAXXContext context, List<String> columnsName) {
        super(null);
        this.pathSeparator = pathSeparator;
        this.context = context;
        this.columnsName = columnsName;
    }

    @Override
    public NavigationTreeTableNode getRoot() {
        return (NavigationTreeTableNode)this.root;
    }

    @Override
    public TreeNode[] getPathToRoot(TreeNode aNode) {
        if (aNode == null) {
            return null;
        }
        return super.getPathToRoot((TreeTableNode)aNode);
    }

    public void setRoot(NavigationTreeTableNode root) {
        this.root = root;
        this.getModelSupport().fireNewRoot();
    }

    public void removeNodeFromParent(NavigationTreeNode node) {
        NavigationTreeTableNode parent = (NavigationTreeTableNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int index = parent.getIndex(node);
        node.removeFromParent();
        this.modelSupport.fireChildRemoved(new TreePath(this.getPathToRoot(parent)), index, (Object)node);
    }

    @Override
    public NavigationTreeNode findNode(String path) {
        return this.findNode((NavigationTreeNode)this.getRoot(), path, (Pattern)null);
    }

    @Override
    public NavigationTreeNode findNode(String path, String regex) {
        return this.findNode((NavigationTreeNode)this.getRoot(), path, regex);
    }

    @Override
    public NavigationTreeNode findNode(String path, Pattern regex) {
        return this.findNode((NavigationTreeNode)this.getRoot(), path, regex);
    }

    @Override
    public NavigationTreeNode findNode(NavigationTreeNode root, String path) {
        return this.findNode(root, path, (Pattern)null);
    }

    @Override
    public NavigationTreeNode findNode(NavigationTreeNode root, String path, String regex) {
        return this.findNode(root, path, regex == null ? null : Pattern.compile(regex));
    }

    @Override
    public NavigationTreeNode findNode(NavigationTreeNode root, String path, Pattern regex) {
        String rootPath;
        if (regex != null) {
            Matcher matcher = regex.matcher(path);
            if (!matcher.matches() || matcher.groupCount() < 1) {
                log.warn((Object)("no matching regex " + regex + " to " + path));
                return null;
            }
            path = matcher.group(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("matching regex " + regex + " : " + path));
            }
        }
        StringTokenizer stk = new StringTokenizer(path, this.pathSeparator);
        NavigationTreeNode result = root;
        if (root.isRoot() && stk.hasMoreTokens() && !(rootPath = stk.nextToken()).equals(root.getNodePath())) {
            return null;
        }
        while (stk.hasMoreTokens()) {
            result = result.getChild(stk.nextToken());
        }
        return result;
    }

    @Override
    public JAXXContext getContext() {
        return this.context;
    }

    @Override
    public Object getBean(String navigationPath) {
        NavigationTreeNode node = this.findNode(navigationPath, (Pattern)null);
        Object result = this.getBean(node);
        return result;
    }

    @Override
    public Object getBean(NavigationTreeNode node) {
        if (node == null) {
            return null;
        }
        return node.getBean(this.getContext());
    }

    protected TreeModelSupport getModelSupport() {
        return this.modelSupport;
    }

    @Override
    public void nodeChanged(TreeNode node) {
        if (node != null) {
            MutableTreeNode parent = (MutableTreeNode)node.getParent();
            Object[] treeNodes = this.getPathToRoot(parent);
            if (treeNodes != null) {
                this.modelSupport.fireChildChanged(new TreePath(treeNodes), parent.getIndex(node), (Object)node);
            } else {
                log.error((Object)"[Node changed] Path to root is null !");
            }
            this.reload((NavigationTreeTableNode)node, true);
        } else {
            log.error((Object)"Node is null !");
        }
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        if (node != null) {
            MutableTreeNode parent = (MutableTreeNode)node.getParent();
            Object[] treeNodes = this.getPathToRoot(parent);
            if (treeNodes != null) {
                this.modelSupport.fireTreeStructureChanged(new TreePath(treeNodes));
            } else {
                log.error((Object)"[Node structure changed] Path to root is null !");
            }
            this.reload((NavigationTreeTableNode)node, true);
        } else {
            log.error((Object)"Node is null !");
        }
    }

    @Override
    public void nodeChanged(TreeNode node, boolean deep) {
        if (node != null) {
            MutableTreeNode parent = (MutableTreeNode)node.getParent();
            Object[] treeNodes = this.getPathToRoot(parent);
            if (treeNodes != null) {
                this.modelSupport.fireChildChanged(new TreePath(treeNodes), parent.getIndex(node), (Object)node);
            } else {
                log.error((Object)"[Node changed] Path to root is null !");
            }
            this.reload((NavigationTreeTableNode)node, deep);
        } else {
            log.error((Object)"Node is null !");
        }
    }

    protected void reload(NavigationTreeTableNode node) {
        this.reload(node, false);
    }

    protected void reload(NavigationTreeTableNode node, boolean deep) {
        if (node == null) {
            return;
        }
        node.reload(this.getContext());
        if (deep) {
            Enumeration<TreeNode> childs = node.children();
            while (childs.hasMoreElements()) {
                NavigationTreeTableNode o = (NavigationTreeTableNode)childs.nextElement();
                this.reload(o, true);
            }
        }
    }

    @Override
    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public int getColumnCount() {
        return this.columnsName.size();
    }

    public String getColumnName(int column) {
        return this.columnsName.get(column);
    }
}

