/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.decorator;

import java.io.File;
import jaxx.runtime.decorator.Data;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorProvider;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DecoratorProviderTest {
    private static final String BY_NAME = "name";
    static DecoratorProvider provider;

    @BeforeClass
    public static void beforeTest() throws Exception {
        provider = new MyDecoratorProvider();
    }

    @Test
    public void testGetDecoratorByObject() throws Exception {
        File f = new File("myFile");
        Data d = new Data(0, BY_NAME);
        Class<File> k = File.class;
        Decorator fileDecorator = provider.getDecorator((Object)f);
        Assert.assertNotNull((Object)fileDecorator);
        Assert.assertEquals(File.class, (Object)fileDecorator.getInternalClass());
        Assert.assertEquals((Object)"myFile", (Object)fileDecorator.toString((Object)f));
        Decorator classDecorator = provider.getDecorator(Class.class);
        Assert.assertNotNull((Object)classDecorator);
        Assert.assertEquals(Class.class, (Object)classDecorator.getInternalClass());
        Assert.assertEquals((Object)"File", (Object)classDecorator.toString(k));
        Decorator dataDecorator = provider.getDecorator((Object)d);
        Assert.assertNotNull((Object)dataDecorator);
        Assert.assertEquals(Data.class, (Object)dataDecorator.getInternalClass());
        Assert.assertEquals((Object)BY_NAME, (Object)dataDecorator.toString((Object)d));
    }

    @Test
    public void testGetDecoratorByObjectAndName() throws Exception {
        File f = new File("myFile");
        Data d = new Data(0, BY_NAME);
        Class<File> k = File.class;
        Decorator fileDecorator = provider.getDecorator((Object)f, BY_NAME);
        Assert.assertNotNull((Object)fileDecorator);
        Assert.assertEquals(File.class, (Object)fileDecorator.getInternalClass());
        Assert.assertEquals((Object)"null", (Object)fileDecorator.toString((Object)f));
        Decorator classDecorator = provider.getDecorator(Class.class, BY_NAME);
        Assert.assertNotNull((Object)classDecorator);
        Assert.assertEquals(Class.class, (Object)classDecorator.getInternalClass());
        Assert.assertEquals((Object)"java.io.File", (Object)classDecorator.toString(k));
        Decorator dataDecorator = provider.getDecorator((Object)d, BY_NAME);
        Assert.assertNotNull((Object)dataDecorator);
        Assert.assertEquals(Data.class, (Object)dataDecorator.getInternalClass());
        Assert.assertEquals((Object)"0", (Object)dataDecorator.toString((Object)d));
    }

    @Test
    public void testGetDecoratorByType() throws Exception {
        File f = new File("myFile");
        Data d = new Data(0, BY_NAME);
        Class<File> k = File.class;
        Decorator fileDecorator = provider.getDecorator(File.class);
        Assert.assertNotNull((Object)fileDecorator);
        Assert.assertEquals(File.class, (Object)fileDecorator.getInternalClass());
        Assert.assertEquals((Object)"myFile", (Object)fileDecorator.toString((Object)f));
        Decorator classDecorator = provider.getDecorator(Class.class);
        Assert.assertNotNull((Object)classDecorator);
        Assert.assertEquals(Class.class, (Object)classDecorator.getInternalClass());
        Assert.assertEquals((Object)"File", (Object)classDecorator.toString(k));
        Decorator dataDecorator = provider.getDecorator(Data.class);
        Assert.assertNotNull((Object)dataDecorator);
        Assert.assertEquals(Data.class, (Object)dataDecorator.getInternalClass());
        Assert.assertEquals((Object)BY_NAME, (Object)dataDecorator.toString((Object)d));
    }

    @Test
    public void testGetDecoratorByTypeAndName() throws Exception {
        File f = new File("myFile");
        Data d = new Data(0, BY_NAME);
        Class<File> k = File.class;
        Decorator fileDecorator = provider.getDecorator(File.class, BY_NAME);
        Assert.assertNotNull((Object)fileDecorator);
        Assert.assertEquals(File.class, (Object)fileDecorator.getInternalClass());
        Assert.assertEquals((Object)"null", (Object)fileDecorator.toString((Object)f));
        Decorator classDecorator = provider.getDecorator(Class.class, BY_NAME);
        Assert.assertNotNull((Object)classDecorator);
        Assert.assertEquals(Class.class, (Object)classDecorator.getInternalClass());
        Assert.assertEquals((Object)"java.io.File", (Object)classDecorator.toString(k));
        Decorator dataDecorator = provider.getDecorator(Data.class, BY_NAME);
        Assert.assertNotNull((Object)dataDecorator);
        Assert.assertEquals(Data.class, (Object)dataDecorator.getInternalClass());
        Assert.assertEquals((Object)"0", (Object)dataDecorator.toString((Object)d));
    }

    @Test
    public void testReload() throws Exception {
        int nb = provider.getDecorators().size();
        Assert.assertTrue((nb > 0 ? 1 : 0) != 0);
        provider.reload();
        Assert.assertEquals((long)nb, (long)provider.getDecorators().size());
    }

    @Test
    public void testClear() throws Exception {
        provider.clear();
        Assert.assertTrue((boolean)provider.getDecorators().isEmpty());
    }

    static class MyDecoratorProvider
    extends DecoratorProvider {
        MyDecoratorProvider() {
        }

        protected void loadDecorators() {
            this.registerPropertyDecorator(File.class, DecoratorProviderTest.BY_NAME);
            this.registerPropertyDecorator(File.class, DecoratorProviderTest.BY_NAME, "parent");
            this.registerJXPathDecorator(Class.class, "${simpleName}$s");
            this.registerJXPathDecorator(Class.class, DecoratorProviderTest.BY_NAME, "${name}$s");
            this.registerMultiJXPathDecorator(Data.class, "${name}$s", "-", " ");
            this.registerMultiJXPathDecorator(Data.class, DecoratorProviderTest.BY_NAME, "${pos}$d", "-", " ");
        }
    }
}

