package jaxx.runtime.validator.swing.ui;

import jaxx.runtime.validator.BeanValidatorScope;
import org.jdesktop.jxlayer.JXLayer;

import javax.swing.JComponent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import jaxx.runtime.validator.BeanValidatorField;

/** @author chemit */
public class TranslucentValidationUI extends AbstractBeanValidatorUI {

    protected Color errorHightlight;
    protected Color warningHightlight;
    protected Color infoHightlight;

    public TranslucentValidationUI(BeanValidatorField field) {
        super(field);
        errorHightlight = Color.RED;
        warningHightlight = Color.YELLOW;
        infoHightlight = Color.GREEN;
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<JComponent> l) {
        // paints the layer as is
        super.paintLayer(g2, l);

        // to be in sync with the view if the layer has a border
        Insets layerInsets = l.getInsets();
        g2.translate(layerInsets.left, layerInsets.top);

        JComponent view = l.getView();
        // To prevent painting on view's border
        Insets insets = view.getInsets();
        g2.clip(new Rectangle(insets.left, insets.top,
                view.getWidth() - insets.left - insets.right,
                view.getHeight() - insets.top - insets.bottom));

        BeanValidatorScope scope = field.getScope();

        if (scope == null) {
            g2.setColor(Color.WHITE);
        } else {
            switch (scope) {
                case ERROR:
                    g2.setColor(errorHightlight);
                    break;
                case WARNING:
                    g2.setColor(warningHightlight);
                    break;
                case INFO:
                    g2.setColor(infoHightlight);
                    break;
            }
        }
        
        g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, .2f));
        g2.fillRect(0, 0, l.getWidth(), l.getHeight());
    }
}
