package jaxx.runtime.validator.swing.ui;

import org.jdesktop.jxlayer.JXLayer;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorScope;

/** @author chemit */
public class ImageValidationUI extends AbstractBeanValidatorUI {

    protected static BufferedImage errorIcon;
    protected static BufferedImage warningIcon;
    protected static BufferedImage infoIcon;

    public ImageValidationUI(BeanValidatorField field) {
        super(field);
        if (errorIcon == null) {
            errorIcon = prepareIcon(jaxx.runtime.Util.createImageIcon("error.png"));
        }
        if (warningIcon == null) {
            warningIcon = prepareIcon(jaxx.runtime.Util.createImageIcon("warning.png"));
        }
        if (infoIcon == null) {
            infoIcon = prepareIcon(jaxx.runtime.Util.createImageIcon("info.png"));
        }
    }

    protected static BufferedImage prepareIcon(ImageIcon image) {
        BufferedImage icon = new BufferedImage(image.getIconWidth(), image.getIconHeight(), BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = (Graphics2D) icon.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.drawImage(image.getImage(), 0, 0, null);
        g2.dispose();
        return icon;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 3));
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setBorder(null);
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<JComponent> l) {
        super.paintLayer(g2, l);
        BeanValidatorScope scope = field.getScope();
        if (scope != null) {
            BufferedImage icon = null;
            switch (scope) {
                case ERROR:
                    icon = errorIcon;
                    break;
                case WARNING:
                    icon = warningIcon;
                    break;
                case INFO:
                    icon = infoIcon;
                    break;
            }
            if (icon != null) {
                g2.drawImage(icon, l.getWidth() - icon.getWidth() - 1, 0, null);
            }
        }
    }
}