package jaxx.runtime.validator.swing;

import javax.swing.JComponent;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorMessage;
import jaxx.runtime.validator.BeanValidatorScope;

/**
 * The object to box a validation message within an u.
 *
 * @author chemit
 * @since 1.3
 * @see BeanValidatorMessage
 */
public class SwingValidatorMessage extends BeanValidatorMessage<SwingValidatorMessage> {

    /**
     * the optional field's editor
     */
    protected JComponent editor;
    protected String fieldName;

    public SwingValidatorMessage(SwingValidator validator, BeanValidatorField field, String message, BeanValidatorScope scope, JComponent editor) {
        super(validator, field, message, scope);
        this.fieldName = field.getName();
        this.editor = editor;
    }

    public SwingValidatorMessage(SwingValidator validator, String fieldName, String message, BeanValidatorScope scope, JComponent editor) {
        super(validator, null, message, scope);
        this.fieldName = fieldName;
        this.editor = editor;
    }

    public JComponent getEditor() {
        return editor;
    }

    public String getFieldName() {
        return fieldName;
    }

    @Override
    public int compareTo(SwingValidatorMessage o) {
        // sort on scope
        int result = getScope().compareTo(o.getScope());
        if (result == 0) {
            // sort on field name
            result = fieldName.compareTo(o.getFieldName());
            if (result == 0) {
                // sort on message
                result = message.compareTo(o.getMessage());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String s = scope + " - " + (field == null ? message : field.getI18nError(message));
        if (editor == null) {
            return s;
        }
        return editor.getName() + " : " + s;
    }
}
