package jaxx.runtime.swing.wizard;

import java.awt.Component;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import javax.swing.JTabbedPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import static org.nuiton.i18n.I18n._;

/**
 * Classe de méthodes utiles sur les wizard.
 *
 * @author tony
 * @since 1.3
 */
public class WizardUtil {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WizardUI.class);

    protected WizardUtil() {
    }

    public static boolean acceptStates(WizardOperationState state, WizardOperationState... accepted) {
        for (WizardOperationState s : accepted) {
            if (s == state) {
                return true;
            }
        }
        return false;
    }

    public static boolean rejectStates(WizardOperationState state, WizardOperationState... rejected) {
        for (WizardOperationState s : rejected) {
            if (s == state) {
                return false;
            }
        }
        return true;
    }

    public static void addDebugLogListener(final Log log, WizardModel<?> model) {
        if (log.isDebugEnabled()) {
            model.addPropertyChangeListener(new PropertyChangeListener() {

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    log.debug(evt.getPropertyName() + " <" + evt.getOldValue() + " - " + evt.getNewValue() + ">");
                }
            });
        }
    }

    public static void addTraceLogListener(final Log log, WizardModel<?> model) {
        if (log.isTraceEnabled()) {
            model.addPropertyChangeListener(new PropertyChangeListener() {

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    log.trace(evt.getPropertyName() + " <" + evt.getOldValue() + " - " + evt.getNewValue() + ">");
                }
            });
        }
    }

    public static <E extends WizardStep, M extends WizardModel<E>> void installWizardUIListeners(final WizardUI<E, M> ui) {
        ui.getModel().addPropertyChangeListener(new PropertyChangeListener() {

            @Override
            @SuppressWarnings("unchecked")
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (WizardOperationModel.WAS_STARTED_PROPERTY_NAME.equals(propertyName)) {
                    ui.onWasStarted();
                    return;
                }
                if (WizardModel.STEPS_PROPERTY_NAME.equals(propertyName)) {
                    java.util.List<E> steps = (java.util.List<E>) evt.getNewValue();
                    ui.onStepsChanged(steps.toArray((E[]) Array.newInstance(ui.getModel().stepClass, steps.size())));
                    return;
                }
                if (WizardModel.STEP_PROPERTY_NAME.equals(propertyName)) {
                    ui.onStepChanged((E) evt.getNewValue());
                    return;
                }
                if (WizardOperationModel.MODEL_STATE_PROPERTY_NAME.equals(propertyName)) {
                    //TODO should be unicast : only for good stepUI ?
                    ui.onModelStateChanged((WizardOperationState) evt.getNewValue());
                    return;
                }
                if (WizardOperationModel.OPERATION_STATE_PROPERTY_NAME.equals(propertyName)) {
                    IndexedPropertyChangeEvent e = (IndexedPropertyChangeEvent) evt;
                    int stepIndex = e.getIndex();
                    E step = ui.getModel().getSteps().get(stepIndex);
                    ui.onOperationStateChanged(step, (WizardOperationState) evt.getNewValue());
                    return;
                }
            }
        });
    }

    /**
     * Ajoute un listener sur le modele pour gere la politique d'affichage des
     * onglets.
     *
     * Dans cette implantation, les onglets sont ouverts jusqu'a l'etape courante.
     * Lorsque l'on revient en arrière, les onglets d'etapes superieurs sont
     * fermes.
     * 
     * @param <E> le type d'un etape de l'assistant
     * @param <M> le type du modele de l'assistant
     * @param ui l'ui de l'assitant
     * @since 1.7.1
     */
    public static <E extends WizardStep, M extends WizardModel<E>> void addTabsDisplayUntilStepListener(final WizardUI<E, M> ui) {
        // on écoute les changements d'étapes
        ui.getModel().addPropertyChangeListener(WizardModel.STEP_PROPERTY_NAME, new PropertyChangeListener() {

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                M model = (M) evt.getSource();
                E oldStep = (E) evt.getOldValue();
                E newStep = (E) evt.getNewValue();
                log.debug("step has changed <old:" + oldStep + ", new:" + newStep + ">");
                int oldStepIndex = oldStep == null ? -1 : model.getStepIndex(oldStep);
                int newStepIndex = model.getStepIndex(newStep);
                JTabbedPane tabs = ui.getTabs();
                if (oldStepIndex + 1 == newStepIndex) {
                    // creation d'un nouvel onglet
                    WizardStepUI<E, M> c = ui.getStepUI(newStep);
                    String title = _(newStep.getLabel());
                    String tip = _(newStep.getDescription());
                    tabs.addTab(title, null, (Component) c, tip);
                    // selection du nouvel onglet
                    int index = tabs.indexOfComponent((Component) c);
                    if (index > -1) {
                        tabs.setSelectedIndex(index);
                    }
                } else if (oldStepIndex > newStepIndex) {
                    // il s'agit d'un retour en arrière
                    // on supprime tous les onglets obsoletes
                    int index = newStepIndex + 1;
                    while (tabs.getTabCount() > index) {
                        log.trace("remove tab : " + index);
                        tabs.remove(index);
                    }
                } else {
                    throw new IllegalStateException("can not go from " + oldStep + " to " + newStep);
                }
            }
        });
    }
}
