package jaxx.runtime.swing.wizard;

/**
 * Pour caractériser l'état d'une opération.
 */
public enum WizardOperationState {

    /**
     * quand l'opération n'a pas encore été réalisée
     */
    PENDING,
    /**
     * quand l'opération est en cours
     */
    RUNNING,
    /**
     * quand l'opération est annulé en cours d'exécution
     */
    CANCELED,
    /**
     * quand une erreur s'est produite pendant l'exécution
     */
    FAILED,
    /**
     * quand l'exécution s'est terminée mais requière des corrections
     */
    NEED_FIX,
    /**
     * quand l'exécution s'est terminée et ne requière pas de correction
     */
    SUCCESSED
}
