/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.runtime.swing;

import javax.swing.JPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;

/**
 * Panel which uses a {@link GridBagLayout} by default.
 *
 * @author Ethan Nicholas
 */
public class Table extends JPanel {

    private static final long serialVersionUID = 1L;
    public static final Insets DEFAULT_INSETS = new Insets(3, 3, 3, 3);
    private GridBagConstraints tableConstraints = new GridBagConstraints();
    private GridBagConstraints rowConstraints = null;
    private GridBagConstraints cellConstraints = null;

    public Table() {
        super.setLayout(new GridBagLayout());

        tableConstraints.insets = DEFAULT_INSETS;
    }

    @Override
    public void setLayout(LayoutManager layout) {
        // do nothing
    }

    public GridBagConstraints getTableConstraints() {
        return tableConstraints;
    }

    public GridBagConstraints getRowConstraints() {
        return rowConstraints;
    }

    public GridBagConstraints getCellConstraints() {
        return cellConstraints;
    }

    public void newRow() {
        tableConstraints.gridy++;
        rowConstraints = (GridBagConstraints) tableConstraints.clone();
    }

    public void newCell() {
        rowConstraints.gridx++;
        cellConstraints = (GridBagConstraints) rowConstraints.clone();
    }
}
