package jaxx.runtime.swing;

import static org.nuiton.i18n.I18n._;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import java.awt.Component;

/**
 * A simple TableCellRenderer using a delegate TableCellRenderer to render everything elese thant the text :
 * the text is I18nalize.
 *
 * @author chemit
 */
public class I18nTableCellRenderer implements TableCellRenderer {

    /** i18n keys of  libelles to display */
    protected final String[] keys;

    /** i18n keys of toolTipTexts to display */
    protected final String[] tips;

    /** the delegate cell renderer */
    protected TableCellRenderer delegate;

    public I18nTableCellRenderer(TableCellRenderer delegate, String... keysAndTips) {
        this.delegate = delegate;
        if (keysAndTips.length == 0) {
            throw new IllegalArgumentException("can not have empty keysAndTips parameters (means no column ?)");
        }
        if (keysAndTips.length % 2 == 1) {
            throw new IllegalArgumentException("must have some couple (text,tooltTipText), but had a even number of data in keysAndTips parameter");
        }
        int size = keysAndTips.length / 2;
        this.keys = new String[size];
        this.tips = new String[size];
        for (int i = 0; i < size; i++) {
            this.keys[i] = keysAndTips[2 * i];
            this.tips[i] = keysAndTips[2 * i + 1];
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasfocus, int row, int column) {
        if (column > keys.length) {
            throw new IndexOutOfBoundsException("colum can not be greater than " + keys.length);
        }
        TableColumn col = table.getColumn(table.getColumnName(column));
        int index = col.getModelIndex();
        value = _(keys[index]);
        JComponent rendererComponent = (JComponent) delegate.getTableCellRendererComponent(table, value, isSelected, hasfocus, row, column);
        rendererComponent.setToolTipText(_(tips[index]));
        return rendererComponent;
    }

    public String[] getKeys() {
        return keys;
    }

    public String[] getTips() {
        return tips;
    }
    
}
