package jaxx.runtime.swing;

import jaxx.runtime.Decorator;

import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import java.awt.Component;

/**
 * A simple TableCellRenderer using a delegate TableCellRenderer to render everything elese thant the text :
 * the text is I18nalize.
 *
 * @author chemit
 */
public class DecoratorTableCellRenderer implements TableCellRenderer {

    /** the delegate cell renderer */
    protected TableCellRenderer delegate;

    protected Decorator decorator;

    public DecoratorTableCellRenderer(TableCellRenderer delegate, Decorator decorator) {
        this.delegate = delegate;
        this.decorator = decorator;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasfocus, int row, int column) {
        if (value != null) {
            value = decorator.toString(value);
        }
        return delegate.getTableCellRendererComponent(table, value, isSelected, hasfocus, row, column);
    }
}