package jaxx.runtime.swing;

import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

/** @author chemit
 * @since 1.5
 */
public class BooleanCellRenderer extends JPanel implements TableCellRenderer {

    private static final long serialVersionUID = 1L;
    protected TableCellRenderer defaultDelegate;
    protected JCheckBox checkBox;

    public BooleanCellRenderer(TableCellRenderer delegate) {
        //super(new BorderLayout());
        this.checkBox = new JCheckBox();
        add(checkBox, BorderLayout.CENTER);
        checkBox.setHorizontalAlignment(JLabel.CENTER);
        checkBox.setBorderPainted(true);
        this.defaultDelegate = delegate;
    }

    public BooleanCellRenderer(TableCellRenderer delegate, Icon icon) {
        //super(new BorderLayout());
        this.checkBox = new JCheckBox(icon);
        add(checkBox, BorderLayout.NORTH);
        checkBox.setHorizontalAlignment(JLabel.CENTER);
        checkBox.setVerticalTextPosition(JLabel.TOP);
        checkBox.setBorderPainted(true);
        this.defaultDelegate = delegate;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ((JComponent) defaultDelegate).setBackground(null);
        JComponent render = (JComponent) defaultDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            setForeground(table.getSelectionForeground());
            setBackground(table.getSelectionBackground());
        } else {
            setForeground(render.getForeground());
            setBackground(render.getBackground());
            //fixme make this works... and remove the test
            if (row % 2 == 1) {
                setBackground(Color.WHITE);
            }
        }
        checkBox.setSelected((value != null && (Boolean) value));
        setBorder(render.getBorder());
        return this;
    }
}
