/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.beaninfos;

import jaxx.runtime.swing.VBox;

import javax.swing.JPanel;
import javax.swing.SwingConstants;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

public class VBoxBeanInfo extends SimpleBeanInfo {
    public BeanInfo[] getAdditionalBeanInfo() {
        try {
            return new BeanInfo[]{Introspector.getBeanInfo(JPanel.class)};
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }


    public PropertyDescriptor[] getPropertyDescriptors() {
        try {
            PropertyDescriptor spacing = new PropertyDescriptor("spacing", VBox.class);
            spacing.setBound(true);

            PropertyDescriptor margin = new PropertyDescriptor("margin", VBox.class);
            margin.setBound(true);

            PropertyDescriptor horizontalAlignment = new PropertyDescriptor("horizontalAlignment", VBox.class);
            horizontalAlignment.setBound(true);
            horizontalAlignment.setValue("enumerationValues", new Object[]{
                    "left", SwingConstants.LEFT, "SwingConstants.LEFT",
                    "center", SwingConstants.CENTER, "SwingConstants.CENTER",
                    "right", SwingConstants.RIGHT, "SwingConstants.RIGHT"
            });

            PropertyDescriptor verticalAlignment = new PropertyDescriptor("verticalAlignment", VBox.class);
            verticalAlignment.setBound(true);
            verticalAlignment.setValue("enumerationValues", new Object[]{
                    "top", SwingConstants.TOP, "SwingConstants.TOP",
                    "middle", SwingConstants.CENTER, "SwingConstants.CENTER",
                    "bottom", SwingConstants.BOTTOM, "SwingConstants.BOTTOM"
            });

            return new PropertyDescriptor[]{spacing, margin, horizontalAlignment, verticalAlignment};
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }
}
