/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.runtime;

import java.io.Serializable;

public class ComponentDescriptor implements Serializable {
    String id;
    String javaClassName;
    String styleClass;
    ComponentDescriptor parent;
    private static final long serialVersionUID = 1L;


    public ComponentDescriptor(String id, String javaClassName, String styleClass, ComponentDescriptor parent) {
        this.id = id;
        this.javaClassName = javaClassName;
        this.styleClass = styleClass;
        this.parent = parent;
    }


    public String getId() {
        return id;
    }


    public String getJavaClassName() {
        return javaClassName;
    }


    public String getStyleClass() {
        return styleClass;
    }


    public ComponentDescriptor getParent() {
        return parent;
    }


    @Override
    public String toString() {
        return "ComponentDescriptor[" + id + ", " + javaClassName + ", " + styleClass + "]";
    }
}