package jaxx.runtime;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;

/**
 * TODO
 *
 * @param <O> type of decorated objects
 * @author chemit
 * @see jaxx.runtime.Decorator
 */
public class MultiJXPathDecorator<O> extends JXPathDecorator<O> {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(MultiJXPathDecorator.class);

    private static final long serialVersionUID = 1L;

    public static <O> MultiJXPathDecorator<O> newDecorator(Class<O> internalClass,
                                                           String expression,
                                                           String separator)
            throws IllegalArgumentException, NullPointerException {

        return newDecorator(internalClass, expression, separator, separator);
    }

    public static <O> MultiJXPathDecorator<O> newDecorator(Class<O> internalClass,
                                                           String expression,
                                                           String separator,
                                                           String separatorReplacement)
            throws IllegalArgumentException, NullPointerException {

        Context<O>[] contexts = createInitialContexts(expression, separator, separatorReplacement);

        return new MultiJXPathDecorator<O>(internalClass, expression, separator, separatorReplacement, contexts);
    }

    protected Context<O>[] contexts;
    protected String separator;
    protected String separatorReplacement;


    public MultiJXPathDecorator(Class<O> internalClass, String expression,
                                String separator, String separatorReplacement,
                                Context<O>[] contexts) throws IllegalArgumentException, NullPointerException {
        super(internalClass, expression, false);
        this.separator = separator;
        this.separatorReplacement = separatorReplacement;
        this.contexts = contexts;

        setContextIndex(0);

        if (log.isDebugEnabled()) {
            log.debug(expression + " --> " + this.context);
        }
    }

    public void setContextIndex(int index) {
        ensureContextIndex(this, index);
        setContext(contexts[index]);
    }

    public int getNbContext() {
        return contexts.length;
    }

    public String getSeparator() {
        return separator;
    }

    public String getSeparatorReplacement() {
        return separatorReplacement;
    }

    @Override
    protected Comparator<O> getComparator(int pos) {
        ensureContextIndex(this, pos);
        Context<O> context1 = contexts[pos];
        return context1.getComparator(0);
    }

    public static <O> Context<O>[] createInitialContexts(String expression, String separator, String separatorReplacement) {
        int sep = expression.indexOf(separator);
        if (sep == -1) {
            Context<O>[] result = MultiJXPathDecorator.newInstance(1);
            result[0] = createInitialContext(expression);
            return result;
        }

        List<String> tokens = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(expression, separator);
        while (stk.hasMoreTokens()) {
            tokens.add(stk.nextToken());
        }

        int nbTokens = tokens.size();
        Context<O>[] contexts = newInstance(nbTokens);
        for (int i = 0; i < nbTokens; i++) {
            StringBuilder buffer = new StringBuilder(expression.length());
            for (int j = 0; j < nbTokens; j++) {
                int index = (i + j) % nbTokens;
                String str = tokens.get(index);
                //todo replace %index with %j
                buffer.append(separatorReplacement).append(str);
            }
            contexts[i] = createInitialContext(buffer.substring(separatorReplacement.length()));
        }
        return contexts;
    }

    protected static void ensureContextIndex(MultiJXPathDecorator<?> decorator, int pos) {
        if (pos < -1 || pos > decorator.contexts.length) {
            throw new ArrayIndexOutOfBoundsException("context index " + pos + " is out of bound, can be inside [" + 0 + "," + decorator.contexts.length + "]");
        }
    }

    @SuppressWarnings("unchecked")
    protected static <O> Context<O>[] newInstance(int size) {
        // fixme how to instanciate a typed array with no checking warning ?
        return new Context[size];
    }

}