package jaxx.demo.component.swing;

/*
 * #%L
 * JAXX :: Demo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class JCheckBoxMenuItemDemo extends JMenuItemDemo {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMMENTS_EDITABLE = "comments.editable";
    public static final String BINDING_COMMENTS_ENABLED = "comments.enabled";
    public static final String BINDING_EMAIL_EDITABLE = "email.editable";
    public static final String BINDING_EMAIL_ENABLED = "email.enabled";
    public static final String BINDING_FIRST_NAME_EDITABLE = "firstName.editable";
    public static final String BINDING_FIRST_NAME_ENABLED = "firstName.enabled";
    public static final String BINDING_LAST_NAME_EDITABLE = "lastName.editable";
    public static final String BINDING_LAST_NAME_ENABLED = "lastName.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWS28SURQ+YGmhD6l9m9ZIaxM10cHHyrRqXxKLoI100cjGC3NbbjvMXO9c7DRG40/wJ+jejYk7V8aFaxdujH/BGBdujecODDB0CiSQMCn3nu873zn3fmf6/hdEbAHz+8RxNFExJStTLb26s/OosE+LcoPaRcG4tARUP6EwhPMwpNfXbQkX8hkFT9bgyXWrzC2Tmk3opQwM2vLIoHaJUinhnB9RtO1krr695PCK8FjrooJY3/75HX6jv34XBnA4qotjKYlOqEYlfRkIM13CGGZ6TpIGMfdQhmDmHuodUWvrBrHth6RMn8ErGMhAPycCySQsdF+yy+HiHS4hvpjOUrOyKWl5g5ataxKSrmAdf2hFj0azD1GFll4v0eLBmuU0Qzh32folDJRxeY0ICRNKrOOhstXlpsBqUkx25ligChmuR8apSQoG1b3EeFQ+RKsgBYvX0aNUZ1LhvTC1PuGPGdwV2M8tYlJDwozvsKo5thVBQ3t0MZ0hBWqg+DGfFHdVBU3XY2O7DC+kOi8JU77gberIFKOG7gIk9O1aotya4rr6PeenjOLpSe8GnG+HvhGAjtAyYUZH6M0A6MhiOlcUlmGoVmHx0756GlstcvEK4a2QaMvJYw1YFZSouKueDAGzvgNAH2oNHzaMEspDRFRwGU8sf9y6j3GratqZFtMqQnf339T4908/P6Y8p05g7snA0KZBgw7iwuJUSKZSx6s2rUhmJLOEL+UhZlMDp5Q7heYChOVq2ygO87l3X1Nw7T6xS0gRGfjx+cvU02+nIJyCQcMieoqo+E2IyZLALliG7vC7K66i4cMoPkfxG0ZH1XwiIfEi0eIZjdnVxFS/dDnxEg/Fs4WEeYxu8UhLuINtnAtoY72WQuzr3/HchxWvlSEs7eyJ4Y12Rp5APzMNZlJ37NUmWuCYG+I2rehWY3IFzTLgnDff51vu8/axboUwSOLtQ/8uV/MniMQpW6hIesdx58+6W4b6615IPUd5zf9tOKN2rWkq4kEwz3hHHrWc7plhqw3DVM8aOjO4YwrnSMrCd8HpZZ1IkigwU0fnn9Dh2Z5VdWbAt43ObG6QI6pnTXxzmazYE6FadgdYIZhhoeeiumM46JmhXRUXe66iO4Z2VXTH0K6KKz1X0R1Duyo6M0joL1G2V5JtWLQuWCKH+H9kqQPJfxcD6pFsCwAA";
    private static final Log log = LogFactory.getLog(JCheckBoxMenuItemDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextArea comments;
    protected JCheckBoxMenuItem editableCheckBox;
    protected JTextField email;
    protected JCheckBoxMenuItem enabledCheckBox;
    protected JTextField firstName;
    protected JTextField lastName;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JMenu $JMenu0;
    private JCheckBoxMenuItemDemo $JMenuItemDemo0 = this;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBoxMenuItemDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JCheckBoxMenuItemDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JCheckBoxMenuItemDemo() {
        $initialize();
    }

    public JCheckBoxMenuItemDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JCheckBoxMenuItemDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JCheckBoxMenuItemDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JCheckBoxMenuItemDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JCheckBoxMenuItemDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextArea getComments() {
        return comments;
    }

    public JCheckBoxMenuItem getEditableCheckBox() {
        return editableCheckBox;
    }

    public JTextField getEmail() {
        return email;
    }

    public JCheckBoxMenuItem getEnabledCheckBox() {
        return enabledCheckBox;
    }

    public JTextField getFirstName() {
        return firstName;
    }

    @Override
    public Table getFramePanel() {
        return (Table) super.getFramePanel();
    }

    public JTextField getLastName() {
        return lastName;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFramePanel() {
        if (!allComponentsCreated) {
            return;
        }
        framePanel.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add(firstName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add(lastName, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add(email, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        framePanel.add($JScrollPane0, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMenuBar() {
        if (!allComponentsCreated) {
            return;
        }
        menuBar.add($JMenu0);
    }

    protected void createComments() {
        $objectMap.put("comments", comments = new JTextArea());
        
        comments.setName("comments");
        comments.setColumns(15);
        comments.setLineWrap(true);
        comments.setWrapStyleWord(true);
    }

    protected void createEditableCheckBox() {
        $objectMap.put("editableCheckBox", editableCheckBox = new JCheckBoxMenuItem());
        
        editableCheckBox.setName("editableCheckBox");
        editableCheckBox.setSelected(true);
        editableCheckBox.setText(_("Editable"));
    }

    protected void createEmail() {
        $objectMap.put("email", email = new JTextField());
        
        email.setName("email");
        email.setColumns(15);
    }

    protected void createEnabledCheckBox() {
        $objectMap.put("enabledCheckBox", enabledCheckBox = new JCheckBoxMenuItem());
        
        enabledCheckBox.setName("enabledCheckBox");
        enabledCheckBox.setSelected(true);
        enabledCheckBox.setText(_("Enabled"));
    }

    protected void createFirstName() {
        $objectMap.put("firstName", firstName = new JTextField());
        
        firstName.setName("firstName");
        firstName.setColumns(15);
    }

    @Override
    protected void createFramePanel() {
        super.createFramePanel();
        framePanel.setName("framePanel");
    }

    protected void createLastName() {
        $objectMap.put("lastName", lastName = new JTextField());
        
        lastName.setName("lastName");
        lastName.setColumns(15);
    }

    @Override
    protected void createMenuBar() {
        super.createMenuBar();
        menuBar.setName("menuBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMenuBar();
        // inline complete setup of $JMenu0
        $JMenu0.add(enabledCheckBox);
        $JMenu0.add(editableCheckBox);
        addChildrenToFramePanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(comments);
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        $JLabel0.setLabelFor(firstName);
        $JLabel1.setLabelFor(lastName);
        $JLabel2.setLabelFor(email);
        $JLabel3.setLabelFor(comments);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JMenuItemDemo0", $JMenuItemDemo0);
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(_("View"));
        createEnabledCheckBox();
        createEditableCheckBox();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("First Name:"));
        $JLabel0.setDisplayedMnemonic(70);
        createFirstName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("Last Name:"));
        $JLabel1.setDisplayedMnemonic(76);
        createLastName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("Email Address:"));
        $JLabel2.setDisplayedMnemonic(69);
        createEmail();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("Comments:"));
        $JLabel3.setDisplayedMnemonic(67);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        SwingUtil.setComponentHeight($JScrollPane0,75);
        SwingUtil.setComponentWidth($JScrollPane0,150);
        createComments();
        // inline creation of $JMenuItemDemo0
        setName("$JMenuItemDemo0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIRST_NAME_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enabledCheckBox != null) {
                    $bindingSources.put("enabledCheckBox.getModel()", enabledCheckBox.getModel());
                    enabledCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    enabledCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_FIRST_NAME_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enabledCheckBox != null) {
                    firstName.setEnabled( enabledCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enabledCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enabledCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    enabledCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_FIRST_NAME_ENABLED));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIRST_NAME_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (editableCheckBox != null) {
                    $bindingSources.put("editableCheckBox.getModel()", editableCheckBox.getModel());
                    editableCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    editableCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_FIRST_NAME_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editableCheckBox != null) {
                    firstName.setEditable( editableCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editableCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("editableCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    editableCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_FIRST_NAME_EDITABLE));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_NAME_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enabledCheckBox != null) {
                    $bindingSources.put("enabledCheckBox.getModel()", enabledCheckBox.getModel());
                    enabledCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    enabledCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_LAST_NAME_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enabledCheckBox != null) {
                    lastName.setEnabled( enabledCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enabledCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enabledCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    enabledCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_LAST_NAME_ENABLED));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_NAME_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (editableCheckBox != null) {
                    $bindingSources.put("editableCheckBox.getModel()", editableCheckBox.getModel());
                    editableCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    editableCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_LAST_NAME_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editableCheckBox != null) {
                    lastName.setEditable( editableCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editableCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("editableCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    editableCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_LAST_NAME_EDITABLE));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EMAIL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enabledCheckBox != null) {
                    $bindingSources.put("enabledCheckBox.getModel()", enabledCheckBox.getModel());
                    enabledCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    enabledCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_EMAIL_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enabledCheckBox != null) {
                    email.setEnabled( enabledCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enabledCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enabledCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    enabledCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_EMAIL_ENABLED));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EMAIL_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (editableCheckBox != null) {
                    $bindingSources.put("editableCheckBox.getModel()", editableCheckBox.getModel());
                    editableCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    editableCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_EMAIL_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editableCheckBox != null) {
                    email.setEditable( editableCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editableCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("editableCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    editableCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_EMAIL_EDITABLE));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENTS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enabledCheckBox != null) {
                    $bindingSources.put("enabledCheckBox.getModel()", enabledCheckBox.getModel());
                    enabledCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    enabledCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_COMMENTS_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enabledCheckBox != null) {
                    comments.setEnabled( enabledCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enabledCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enabledCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    }
                    enabledCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_COMMENTS_ENABLED));
                }
            }
        
            public void $pr$u6(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENTS_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (editableCheckBox != null) {
                    $bindingSources.put("editableCheckBox.getModel()", editableCheckBox.getModel());
                    editableCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    editableCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_COMMENTS_EDITABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editableCheckBox != null) {
                    comments.setEditable( editableCheckBox.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editableCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("editableCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    }
                    editableCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JCheckBoxMenuItemDemo.this, BINDING_COMMENTS_EDITABLE));
                }
            }
        
            public void $pr$u7(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}