package jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2019 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.SimpleTimeEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SimpleTimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_DATE = "editor.date";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Ty27TQBSdhDyaBCjQh4papBIqlKDKKY8NagWFlgJReIh0UZEN43hIpprYw3hMXaEiPoFPgD0bJHasEAvWLNggfgEhFmwRd8aOk7RuGxEptnUfZ849c8+7nyjtCnR2E/u+ITxb0g4xqjc2Nh6Ym6QpV4nbFJRLR6Dgl0iiZAMVrCjuSnSuUVPtlbC9suJ0uGMTu697sYbyrtxmxG0TIiU6M9jRdN1KPUov+twTXdSIVBzqm9+/kq+tV2+TCPkc2GVhlNnDunqTpGooSS2JTsFJz3GFYbsFNAS1W8D3mIqtMOy693GHPEMvUbaGMhwLAJOoOPzIGkP3+1yiwtwq6TgPsU3YgkRXNFkLIkazC2HoGLEogBh12uGMrMMZt3RANXOu4TIS5VTnPcciTKKr/wOle3t42bl1bDICxKYGVHS3QBND51RlLmooNB37KW3pcUBHJZkfVld1UNWNRuWZgIpEF2Lg96E5iJAXxPWYVNgqMj6YHZmr1rCplR3koqOqaIrDikwPnA7LZ/SWr7cdiQZKCw/CoEZj774+glSwqVO7NlUB6uzfybFvH398WOuuZwbOnogt7XMXrA0XDidCUnX0aLCbnqSscg/zxQbKuYSBNbX1ZmKI1cM0kIPzTqp2Q7Ubd7DbBoh09vunz5NPvh5ByTWUZw621rCqv4tysg3yth1m+fz6smZ0dGsEnifgn4TrMx1hATG09MImW7PrVDJi3dSxkiwVFRO9f7bXMYkI7zPYEE9gSR27WC7vAA7D244HLprQOLcFtWo6UlqYv1je8UHTmRhNo8HM3Jc/Y/X3y11dEzDn6X3Le9qmH6MMtRm1iTZ+6OlYoxe4SzzL6Xk3zs1o0AA8NFJRP8/vUTDVp+DlgxVUQ4T6Ba9AuJSFJVGyRb43WkQqr5RUeiRcnG2oVAjwMgm2gWWvAdRV7Oa1bOrLQJEvDxugfwUuDT1ARx276+LHdXfQF159OZZZn98PY5fowz++BErhWZPaFvj/2h7khHrmh0EM5lX5ajzK5BAoKUl8eQDGNGD8AzOcjMCKBwAA";
    private static final Log log = LogFactory.getLog(SimpleTimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configPanel;
    protected SimpleTimeEditorDemoModel demoModel;
    protected SimpleTimeEditor editor;
    protected final SimpleTimeEditorDemoHandler handler = createHandler();
    protected JPanel resultPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SimpleTimeEditorDemo $DemoPanel0 = this;
    private JLabel $JLabel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SimpleTimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SimpleTimeEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimpleTimeEditorDemo() {
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SimpleTimeEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigPanel() {
        return configPanel;
    }

    public SimpleTimeEditorDemoModel getDemoModel() {
        return demoModel;
    }

    public SimpleTimeEditor getEditor() {
        return editor;
    }

    public SimpleTimeEditorDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPane() {
        return resultPane;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToResultPane() {
        if (!allComponentsCreated) {
            return;
        }
        resultPane.add($JLabel0, BorderLayout.CENTER);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new JPanel());
        
        configPanel.setName("configPanel");
        configPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDemoModel() {
        $objectMap.put("demoModel", demoModel = new SimpleTimeEditorDemoModel());
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new SimpleTimeEditor(this));
        
        editor.setName("editor");
        editor.setProperty("time");
    }

    protected SimpleTimeEditorDemoHandler createHandler() {
        return new SimpleTimeEditorDemoHandler();
    }

    protected void createResultPane() {
        $objectMap.put("resultPane", resultPane = new JPanel());
        
        resultPane.setName("resultPane");
        resultPane.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToResultPane();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        editor.setBorder(new TitledBorder(t("jaxxdemo.timeeditor.editor")));
        configPanel.setBorder(new TitledBorder(t("jaxxdemo.numbereditor.configuration")));
        editor.setBean(demoModel);
        resultPane.setBorder(new TitledBorder(t("jaxxdemo.timeeditor.model")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createDemoModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigPanel();
        createEditor();
        createResultPane();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoModel != null) {
                    demoModel.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoModel != null) {
                    $JLabel0.setText(t(t("jaxxdemo.timeeditor.value", demoModel.getTime())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoModel != null) {
                    demoModel.removePropertyChangeListener("time", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoModel != null) {
                    demoModel.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoModel != null) {
                    editor.setDate(demoModel.getTime());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoModel != null) {
                    demoModel.removePropertyChangeListener("time", this);
                }
            }
        });
    }

}
