package jaxx.demo.fun;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.HBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class CounterDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JTEXT_FIELD0_TEXT = "$JTextField0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTPW8TQRAdH7aD44QABuOIgEywIgp0BlpHEJLICpb5EE4R4Ya1bxNfdL5bdufI0SB+Aj8BehokOipEQU1Bg/gLCFHQImbvbJ+NLyISLtanmXlv38y8ffMdMkrCpX0WBKb0XbT73Gzc3tm539nnXdzkqittgZ6E6JcywGhD3hrFFcLldlPDqwN4dcPrC8/l7hi61oRZhc8crnqcI8KFSURXqWprlK4FwpdD1pGoJNZXP38YL60Xrw2AQJC6LLVS/hcq7iTdBMO2EE7TTU9Z1WHuHsmQtrtHeud1bMNhSt1jff4EnsNME7KCSSJDWD56yyFHiA8EQr6yyfveA+Zy5xrCYijWooi567uklvi41BVChJgswlylsc0DrNvcsQhS1LoCUx2QTDPO6OLcCJOtbK17AVWfm5hGBNKpyfJcpbHuI3ouIQoT/FFYly1MV1/XgTOHJG+MJyWcnxBCCzfjhccbSbUhI30KI5Ta0x55SKnIHaW/3KEJw+zvYuHL+2/v6kNLpOnus4mlY46mVQnpCS7R1lcvRH7w0Xaqd5motSGnuEPPIbT7UoKw1iBN4ui+Uxpuari5xVSPKDIzXz98LD7+fAyMOsw6HrPqTNffgRz2JE3Bc6xA3FoLFc0dHKfzpNaGkEbaMMKJVYshK3ds16K93AxoBEsJIxjp6OQ+/Sq03q4Nx5AiWYuHlsejyDyCrO06tsvDtzGwfeJbyAvFfcuL7Z1k+JT+nxcDN18Mz+XpPnW4Qg9xNbq7zJCeYcdHTp3q3ErYgv66EtYWjsaoj6vJDMX/ZigRwx+o08FUPwUAAA==";
    private static final Log log = LogFactory.getLog(CounterDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CounterDemo $DemoPanel0 = this;
    private HBox $HBox0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JTextField $JTextField0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    int count;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CounterDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CounterDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CounterDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CounterDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CounterDemo() {
        $initialize();
    }

    public CounterDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public CounterDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public CounterDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        count--;
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        count = 0;
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        count++;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JTextField get$JTextField0() {
        return $JTextField0;
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($JTextField0, BorderLayout.NORTH);
        add($HBox0, BorderLayout.SOUTH);
        // inline complete setup of $HBox0
        $HBox0.add($JButton0);
        $HBox0.add($JButton1);
        $HBox0.add($JButton2);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $JTextField0
        $objectMap.put("$JTextField0", $JTextField0 = new JTextField());
        
        $JTextField0.setName("$JTextField0");
        $JTextField0.setColumns(15);
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("Dec (-)"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("Reset"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("Inc (+)"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTEXT_FIELD0_TEXT, true ,"count") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText($JTextField0, count+"");
            }
        });
    }

}
