package jaxx.demo.component.jaxx.widgets.number;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class NumberEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVPW8TQRDdmNghcUJIQqIgvgJENKBzkCiA8J1gQeSEKEkR4Ya1b7EvnHeP3Tl8NIifwE+AngaJjgpRUFPQIP4CQhS0iNk9+85nznFEXNzZ++a9eTsaz7z9QbJKktM7NAgs6XNwGsxaub29/aCyw6qwzFRVOh4IScLPQIZkyiRvR+cKyNlySdMLLXphSTQ8wRnvYC+WyIiC5y5TdcYAyIkko6pUYTOCFwPPl23VyFSa6utfPzOv7JdvMoQEHrqbxavM9WPFNxkskYxjA5nETM9owaW8hjakw2vod0yfLblUqTXaYE/JCzJUIjmPShQDcmbvVzYahh94QPLzy6wh1iln7gKQy8asjSdWtS1hmbOmY9cYKIv7jQqT1pp53bUdVNYCnmckc0CyDWEzF8j1/5Va1fxYb2h+i1ZchuZmE5VUTayLZTAdORwRTvIOwSXBHzs1X1JwBDe31FET+jEeMcZVXTTXhed7d3wAwYFM62IHrRwrS3VWfXJHBDp8MsnaYIpByNLHM10h1AfRIZwSMuVwYDUmwyqEdrEDEvlLtBL6jmlHErR1CsAk+p5J8LZYAEWHufZu3Ltcl9BOsTbx2BUUOo1p4EQyaLIjqGVDI3O9o3onnLSFj1CfjFOdUb1TJsJ65zw4v9Ju/mTRo2aJ+2SsVbiwtYCcF7KGXYw/eN/O1hKFSClv6hEjl5LwaOi9J56XTPkuRBYvdvkM4fuh26iEV7r5RW0iBR4N4WVjohOX5FjiP4hz0ornZDzIBsokK308xj9t+d/RuoFQOFRnu4aqFjTon5mprx++vy+2J2kOc0+nhnYsApxwnhQek+Do1OPhGPXBcQur1Fssk2HFXNwiZkscTzG22YLRHOab0HRL0617VNVRIjv07eOnmUdfDpBMkYxg9ewi1fH3yTDUsWh14dqBd/OWcTTaPIjPw9obkJxLnwucAeTQNZsCnas43MY2uxFgEY6nFCFyUhn+/Htq892tdiEG0NjRnuFxMbIPSc7hrsOZWSqtfZG6RPKeYr4t4r2QtikG9HvEa83lonmupN10EHDqaHQ18PVrzZjW39aNxqm+Gvp4axeFc/tWuLAnhdIuCgv7VriKCn8BeGu0NO4IAAA=";
    private static final Log log = LogFactory.getLog(NumberEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox autoPopupButton;
    protected NumberEditor doubleEditor;
    protected JLabel doubleNumberConfig;
    protected JCheckBox doubleNumberEnabled;
    protected JTextField doubleNumberPattern;
    protected NumberEditor floatEditor;
    protected JLabel floatNumberConfig;
    protected JCheckBox floatNumberEnabled;
    protected JTextField floatNumberPattern;
    protected final NumberEditorDemoHandler handler = createHandler();
    protected NumberEditor integerEditor;
    protected JLabel integerNumberConfig;
    protected JCheckBox integerNumberEnabled;
    protected JTextField integerNumberPattern;
    protected NumberEditorDemoModel model;
    protected Table numberEditorConfigurationPanel;
    protected JLabel resultDouble;
    protected JLabel resultFloat;
    protected JLabel resultInteger;
    protected JPanel resultPanel;
    protected JCheckBox showPopupButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NumberEditorDemo $DemoPanel0 = this;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public NumberEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditorDemo() {
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public NumberEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public NumberEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAutoPopupButton() {
        return autoPopupButton;
    }

    public NumberEditor getDoubleEditor() {
        return doubleEditor;
    }

    public JLabel getDoubleNumberConfig() {
        return doubleNumberConfig;
    }

    public JCheckBox getDoubleNumberEnabled() {
        return doubleNumberEnabled;
    }

    public JTextField getDoubleNumberPattern() {
        return doubleNumberPattern;
    }

    public NumberEditor getFloatEditor() {
        return floatEditor;
    }

    public JLabel getFloatNumberConfig() {
        return floatNumberConfig;
    }

    public JCheckBox getFloatNumberEnabled() {
        return floatNumberEnabled;
    }

    public JTextField getFloatNumberPattern() {
        return floatNumberPattern;
    }

    public NumberEditorDemoHandler getHandler() {
        return handler;
    }

    public NumberEditor getIntegerEditor() {
        return integerEditor;
    }

    public JLabel getIntegerNumberConfig() {
        return integerNumberConfig;
    }

    public JCheckBox getIntegerNumberEnabled() {
        return integerNumberEnabled;
    }

    public JTextField getIntegerNumberPattern() {
        return integerNumberPattern;
    }

    public NumberEditorDemoModel getModel() {
        return model;
    }

    public Table getNumberEditorConfigurationPanel() {
        return numberEditorConfigurationPanel;
    }

    public JLabel getResultDouble() {
        return resultDouble;
    }

    public JLabel getResultFloat() {
        return resultFloat;
    }

    public JLabel getResultInteger() {
        return resultInteger;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JCheckBox getShowPopupButton() {
        return showPopupButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToNumberEditorConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        numberEditorConfigurationPanel.add(showPopupButton, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(showResetButton, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(autoPopupButton, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberConfig, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberPattern, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberEnabled, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberConfig, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberPattern, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberEnabled, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberConfig, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberPattern, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberEnabled, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
    }

    protected void addChildrenToResultPanel() {
        if (!allComponentsCreated) {
            return;
        }
        resultPanel.add(resultInteger);
        resultPanel.add(resultFloat);
        resultPanel.add(resultDouble);
    }

    protected void createAutoPopupButton() {
        $objectMap.put("autoPopupButton", autoPopupButton = new JCheckBox());
        
        autoPopupButton.setName("autoPopupButton");
    }

    protected void createDoubleEditor() {
        $objectMap.put("doubleEditor", doubleEditor = new NumberEditor(this));
        
        doubleEditor.setName("doubleEditor");
    }

    protected void createDoubleNumberConfig() {
        $objectMap.put("doubleNumberConfig", doubleNumberConfig = new JLabel());
        
        doubleNumberConfig.setName("doubleNumberConfig");
    }

    protected void createDoubleNumberEnabled() {
        $objectMap.put("doubleNumberEnabled", doubleNumberEnabled = new JCheckBox());
        
        doubleNumberEnabled.setName("doubleNumberEnabled");
    }

    protected void createDoubleNumberPattern() {
        $objectMap.put("doubleNumberPattern", doubleNumberPattern = new JTextField());
        
        doubleNumberPattern.setName("doubleNumberPattern");
        doubleNumberPattern.setColumns(15);
    }

    protected void createFloatEditor() {
        $objectMap.put("floatEditor", floatEditor = new NumberEditor(this));
        
        floatEditor.setName("floatEditor");
    }

    protected void createFloatNumberConfig() {
        $objectMap.put("floatNumberConfig", floatNumberConfig = new JLabel());
        
        floatNumberConfig.setName("floatNumberConfig");
    }

    protected void createFloatNumberEnabled() {
        $objectMap.put("floatNumberEnabled", floatNumberEnabled = new JCheckBox());
        
        floatNumberEnabled.setName("floatNumberEnabled");
    }

    protected void createFloatNumberPattern() {
        $objectMap.put("floatNumberPattern", floatNumberPattern = new JTextField());
        
        floatNumberPattern.setName("floatNumberPattern");
        floatNumberPattern.setColumns(15);
    }

    protected NumberEditorDemoHandler createHandler() {
        return new NumberEditorDemoHandler();
    }

    protected void createIntegerEditor() {
        $objectMap.put("integerEditor", integerEditor = new NumberEditor(this));
        
        integerEditor.setName("integerEditor");
    }

    protected void createIntegerNumberConfig() {
        $objectMap.put("integerNumberConfig", integerNumberConfig = new JLabel());
        
        integerNumberConfig.setName("integerNumberConfig");
    }

    protected void createIntegerNumberEnabled() {
        $objectMap.put("integerNumberEnabled", integerNumberEnabled = new JCheckBox());
        
        integerNumberEnabled.setName("integerNumberEnabled");
    }

    protected void createIntegerNumberPattern() {
        $objectMap.put("integerNumberPattern", integerNumberPattern = new JTextField());
        
        integerNumberPattern.setName("integerNumberPattern");
        integerNumberPattern.setColumns(15);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(NumberEditorDemoModel.class));
    }

    protected void createNumberEditorConfigurationPanel() {
        $objectMap.put("numberEditorConfigurationPanel", numberEditorConfigurationPanel = new Table());
        
        numberEditorConfigurationPanel.setName("numberEditorConfigurationPanel");
    }

    protected void createResultDouble() {
        $objectMap.put("resultDouble", resultDouble = new JLabel());
        
        resultDouble.setName("resultDouble");
    }

    protected void createResultFloat() {
        $objectMap.put("resultFloat", resultFloat = new JLabel());
        
        resultFloat.setName("resultFloat");
    }

    protected void createResultInteger() {
        $objectMap.put("resultInteger", resultInteger = new JLabel());
        
        resultInteger.setName("resultInteger");
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new GridLayout(0,1));
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = new JCheckBox());
        
        showPopupButton.setName("showPopupButton");
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(numberEditorConfigurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToNumberEditorConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(integerEditor);
        $JPanel0.add(floatEditor);
        $JPanel0.add(doubleEditor);
        addChildrenToResultPanel();
        
        // apply 6 property setters
        SwingUtil.setText(integerNumberPattern, "-?\\d{0,3}");
        
        SwingUtil.setText(floatNumberPattern, "\\d{0,1}.\\d{0,2}");
        
        SwingUtil.setText(doubleNumberPattern, "-?\\d{0,4}.\\d{0,6}");
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNumberEditorConfigurationPanel();
        createShowPopupButton();
        createShowResetButton();
        createAutoPopupButton();
        createIntegerNumberConfig();
        createIntegerNumberPattern();
        createIntegerNumberEnabled();
        createFloatNumberConfig();
        createFloatNumberPattern();
        createFloatNumberEnabled();
        createDoubleNumberConfig();
        createDoubleNumberPattern();
        createDoubleNumberEnabled();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout());
        createIntegerEditor();
        createFloatEditor();
        createDoubleEditor();
        createResultPanel();
        createResultInteger();
        createResultFloat();
        createResultDouble();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
        handler.afterInit(this);
    }

}