package jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanComboBoxDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTTU8UQRCtXdmFZZHlQwgqJKjEgx+z3DGKQIiS9SPAgbgXe2ZadnC2u+3ukeFi/An+BL17MfHmyXjw7MGL8S8Y48Grsbp3dpaBAUycQ8+kqt7rVzWv3v6AkpJwYYfEsSMjpoM2ddZub209cHeop1eo8mQgNJfQeQpFKDah6qdxpeFSs2Hg9QReX+ZtwRll+9ALDRhUei+kqkWp1jCTRXhK1TfS9EIsItllTUXlsb7+9bP4yn/5pggQC1RXwVZmT0L1OulrQDHwNYzhTc9JPSRsG2XIgG2j3tMmthwSpe6TNn0GL6C/AWVBJJJpuPjvLVsOi4+FhurcCm3zh4TRcF7DvBXrY8TxuhSOjVE/QBJniRKG5C5f4rEBCmGpyhr65zaJG1Ikmcp0rHZRv2NzprKSAsY8zp4E25EkOuDMKsCg6TJOQGs2aMqHeigSaW7aC6mmS5HWnGmYyKCWW9R7ivoMopYCa6rFd9eporqDMuEz2ZJxU7JCPY6SuDyybMBLBqDhak6ryaRcnFRmXNk+qpKqKNRph6PZ9LCiIfqd+uu27OBgGsTtwKYFWux8RgWa1+mZt+euQhNKMsIw/qHmYb+vY6rj9KkDTjeENvtncvzrh+/vV7v27sO7J3JL920n2k5ILqjUgbm61vF2pIOwfo+IhSYuiW3Vru50jrCNJI3i8L5RA3cM3LlDVAspSv3fPn6afPzlFBRXYTDkxF8lpv4uVHQLp9zioR+LW4tW0dDuAJ4jRpuGckj2OP5lGL7hE01m3YD5ON6bMQ5hOmcIqRK38vn3+Ma7xe4gCijs7JHlvWGUHkE5YGHAqN30ZIlzN7sqFI183lvWvPUtmPegSJbwsj2vHO7UhK+Z43ocmZdjJZuveZsbOZEBTW/8vLkn6DE85/5byQwy/AU4xFYDAwYAAA==";
    private static final Log log = LogFactory.getLog(BeanComboBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox autoCompleteButton;
    protected BeanComboBox<People> comboBox;
    protected JPanel configurationPanel;
    protected final BeanComboBoxDemoHandler handler = createHandler();
    protected JPanel resultPanel;
    protected JLabel selectedResult;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanComboBoxDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanComboBoxDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanComboBoxDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BeanComboBoxDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanComboBoxDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanComboBoxDemo() {
        $initialize();
    }

    public BeanComboBoxDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BeanComboBoxDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanComboBoxDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAutoCompleteButton() {
        return autoCompleteButton;
    }

    public BeanComboBox<People> getComboBox() {
        return comboBox;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public BeanComboBoxDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JLabel getSelectedResult() {
        return selectedResult;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(autoCompleteButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
    }

    protected void addChildrenToResultPanel() {
        if (!allComponentsCreated) {
            return;
        }
        resultPanel.add(selectedResult, BorderLayout.CENTER);
    }

    protected void createAutoCompleteButton() {
        $objectMap.put("autoCompleteButton", autoCompleteButton = new JCheckBox());
        
        autoCompleteButton.setName("autoCompleteButton");
    }

    protected void createComboBox() {
        $objectMap.put("comboBox", comboBox = new BeanComboBox<People>());
        
        comboBox.setName("comboBox");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected BeanComboBoxDemoHandler createHandler() {
        return new BeanComboBoxDemoHandler();
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new BorderLayout());
    }

    protected void createSelectedResult() {
        $objectMap.put("selectedResult", selectedResult = new JLabel());
        
        selectedResult.setName("selectedResult");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(comboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfigurationPanel();
        addChildrenToResultPanel();
        
        // apply 4 property setters
        comboBox.setBeanType(People.class);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createAutoCompleteButton();
        createShowResetButton();
        createShowDecoratorButton();
        createComboBox();
        createResultPanel();
        createSelectedResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
        handler.afterInit(this);
    }

}