/*
 * *##% 
 * JAXX Demo
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.demo;

import jaxx.demo.component.jaxx.BoxedDecoratorDemo;
import jaxx.demo.component.jaxx.StatusMessagePanelDemo;
import jaxx.demo.component.jaxx.editor.ComboEditorDemo;
import jaxx.demo.component.jaxx.editor.I18nEditorDemo;
import jaxx.demo.component.jaxx.editor.NumberEditorDemo;
import jaxx.demo.component.jaxx.navigation.FullNavigationTreeDemo;
import jaxx.demo.component.swing.*;
import jaxx.demo.feature.databinding.BeanDataBindingDemo;
import jaxx.demo.feature.databinding.BindingExtremeDemo;
import jaxx.demo.feature.validation.ValidationListDemo;
import jaxx.demo.feature.validation.ValidationTableDemo;
import jaxx.demo.fun.CalculatorDemo;
import jaxx.demo.fun.CounterDemo;
import jaxx.demo.fun.LabelStyleDemo;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.handler.AbstractNavigationHandler;
import jaxx.runtime.swing.navigation.handler.NavigationHandler;
import jaxx.runtime.swing.navigation.handler.NavigationTreeHandlerWithCardLayout;
import jaxx.runtime.swing.navigation.tree.NavigationTreeHelper;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;
import java.util.Stack;

import static org.nuiton.i18n.I18n.n_;

/** @author chemit */
public class DemoTreeHelper extends NavigationTreeHelper {

    static private final Log log = LogFactory.getLog(DemoTreeHelper.class);

    public DemoTreeHelper() {
        super("demo");
    }

    @Override
    public NavigationTreeModel createTreeModel(JAXXContext context) {

        if (log.isDebugEnabled()) {
            log.debug("start creating demo model");
        }

        TreeModelBuilder builder = new TreeModelBuilder(context);

        builder.addText(n_("jaxxdemo.tree.component.swing")).
                addText(n_("jaxxdemo.tree.component.swing.buttons")).
                addDemo(JButtonDemo.class).
                addDemo(JCheckBoxDemo.class).
                addDemo(JRadioButtonDemo.class).
                addDemo(JToggleButtonDemo.class).
                goUp().
                addText(n_("jaxxdemo.tree.component.swing.form")).
                addText(n_("jaxxdemo.tree.component.swing.form.text")).
                addDemo(JPasswordFieldDemo.class).
                addDemo(JTextFieldDemo.class).
                addDemo(JTextAreaDemo.class).
                goUp().
                addDemo(JComboBoxDemo.class).
                addDemo(JListDemo.class).
                addDemo(JSliderDemo.class).
                addDemo(JSpinnerDemo.class).
                goUp().
                addText(n_("jaxxdemo.tree.component.swing.layout")).
                addDemo(JSplitPaneDemo.class).
                goUp().
                addText(n_("jaxxdemo.tree.component.swing.menu")).
                addDemo(JMenuItemDemo.class).
                addDemo(JCheckBoxMenuItemDemo.class).
                addDemo(JRadioButtonMenuItemDemo.class).
                goUp().
                addText(n_("jaxxdemo.tree.component.swing.window")).
                addDemo(JDialogDemo.class).
                goUp().
                addDemo(JProgressBarDemo.class).
                goUp().
                addText(n_("jaxxdemo.tree.component.jaxx")).
                addDemo(HidorButtonDemo.class).
                addText(n_("jaxxdemo.tree.component.jaxx.editor")).
                addDemo(NumberEditorDemo.class).
                addDemo(ComboEditorDemo.class).
                addDemo(I18nEditorDemo.class).
                goUp().
                addText(n_("jaxxdemo.tree.component.jaxx.tree.navigation")).
                addDemo(FullNavigationTreeDemo.class).
                goUp().
                addDemo(BoxedDecoratorDemo.class).
                addDemo(StatusMessagePanelDemo.class).
                goUp().
                addText(n_("jaxxdemo.tree.feature")).
                addText(n_("jaxxdemo.tree.features.databinding")).
                addDemo(BindingExtremeDemo.class).
                addDemo(BeanDataBindingDemo.class).
                goUp().
                addText(n_("jaxxdemo.tree.features.validation")).
                addDemo(ValidationListDemo.class).
                addDemo(ValidationTableDemo.class).
                goUp().
                goUp().
                addText(n_("jaxxdemo.tree.fun")).
                addDemo(LabelStyleDemo.class).
                addDemo(CounterDemo.class).
                addDemo(CalculatorDemo.class);

        NavigationTreeModel model = builder.getModel();

        if (log.isDebugEnabled()) {
            builder.printModel(model.getRoot());
        }
        // save tree model in context
        setModel(context, model);
        return model;
    }

    @Override
    public NavigationHandler<NavigationTreeNode> createTreeHandler(JAXXObject context) {

        NavigationHandler<NavigationTreeNode> handler;

        handler = new NavigationTreeHandlerWithCardLayout<NavigationTreeNode>(
                getPrefix(),
                context,
                NavigationHandler.Strategy.PER_UI_TYPE) {

            private static final long serialVersionUID = 1L;

            @Override
            public NavigationTreeModel getNavigationTreeModel() {
                return (NavigationTreeModel) getModel(getContext());
            }

            @Override
            protected JPanel getContentContainer() {
                return getContext().getContent();
            }

            @Override
            protected CardLayout2 getContentLayout() {
                return getContext().getContentLayout();
            }

            @Override
            public void treateError(Exception e) {
                ErrorDialogUI.showError(e);
            }

            @Override
            public DemoUI getContext() {
                return (DemoUI) context;
            }
        };
        // on ne peut selectionner qu'un seul noeud a la fois
        handler.setSelectionMode(NavigationHandler.SINGLE_TREE_SELECTION);

        // save handler in ui context
        setTreeHandler(context, handler);
        return handler;
    }

    static class TreeModelBuilder extends NavigationTreeModelBuilder {

        /** la definition de l'unqiue object a partage */
        static private final JAXXContextEntryDef<DemoConfig> def =
                JAXXUtil.newContextEntryDef(DemoConfig.class);

        /** la pile des noeuds parent */
        protected Stack<NavigationTreeNode> nodes;

        protected TreeModelBuilder(JAXXContext context) {
            super("/", context, DemoPanel.class, null);
            nodes = new Stack<NavigationTreeNode>();
            nodes.add(buildEmptyRoot(def, "$root"));
        }

        protected TreeModelBuilder goUp() {
            nodes.pop();
            return this;
        }

        protected TreeModelBuilder addText(String label) {
            NavigationTreeNode parentNode = nodes.peek();
            parentNode = build(parentNode, label, def, label, null, null);
            if (log.isDebugEnabled()) {
                log.debug(label + " [" + parentNode.getFullPath() + "]");
            }
            nodes.push(parentNode);
            return this;
        }

        protected TreeModelBuilder addDemo(Class<? extends DemoPanel> demoClass) {
            NavigationTreeNode parentNode = nodes.peek();
            String label = demoClass.getSimpleName();
            if (log.isDebugEnabled()) {
                log.debug(label + " [" + parentNode.getFullPath() + "]");
            }
            build(parentNode, label, def, label, demoClass, null);
            return this;
        }
    }
}
