/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: JXLayerHandler.java 2228 2011-02-19 21:56:44Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.5/jaxx-compiler/src/main/java/jaxx/compiler/tags/swing/JXLayerHandler.java $
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.compiler.tags.swing;

import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.tags.DefaultComponentHandler;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.jxlayer.JXLayer;

import java.awt.Component;

/**
 * To deal with JXLayer, since from version 3.0.4, we can not use any longer
 * the {@link JXLayer#add(Component)} ! but must now use the
 * method {@link JXLayer#setView(Component)}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.4
 */
public class JXLayerHandler extends DefaultComponentHandler {

    public static final String ATTRIBUTE_ORIENTATION = "orientation";

    public static final String ORIENTATION_VALUE_HORIZONTAL = "horizontal";

    public static final String ORIENTATION_VALUE_VERTICAL = "vertical";

    public static final String ORIENTATION_VALUE_VERTICAL_SPLIT = "vertical_split";

    public static final String ORIENTATION_VALUE_HORIZONTAL_SPLIT = "horizontal_split";

    public JXLayerHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(getClass(), beanClass, JXLayer.class);
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledObject(id, getBeanClass(), compiler) {

            @Override
            public void addChild(CompiledObject child,
                                 String constraints,
                                 JAXXCompiler compiler) throws CompilerException {

                if (constraints != null) {
                    compiler.reportError("JXLayer does not accept constraints");
                    return;
                }
                if (CollectionUtils.isNotEmpty(getChilds())) {

                    // already one child, authrozied only one child...
                    compiler.reportError("JXLayer is limited to one children");
                    return;
                }
                super.addChild(child, constraints, compiler);

            }

            @Override
            protected ChildRef newChildRef(CompiledObject child, String constraints, String delegateCode) {
                return new ChildRef(child,
                                    constraints,
                                    child.getJavaCode(),
                                    delegateCode) {
                    @Override
                    public void addToAdditionCode(StringBuilder buffer, boolean isRootObject) {
                        //TC-20091026 do not prefix if on root object
                        String prefix;
                        if (isRootObject) {
                            prefix = "";
                        } else {
                            prefix = getJavaCode() + getDelegateCode() + ".";
                        }
                        buffer.append(prefix);
                        buffer.append("setView(");
                        buffer.append(getChildJavaCode());
                        buffer.append(");");
                        buffer.append(JAXXCompiler.getLineSeparator());
                    }
                };
            }
        };
    }
}