/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tools.jaxxcapture;

import java.awt.Component;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.tools.jaxxcapture.AbstractContextNode;
import jaxx.compiler.tools.jaxxcapture.ContextNode;
import jaxx.compiler.tools.jaxxcapture.JAXXCapture;
import jaxx.compiler.tools.jaxxcapture.handlers.ObjectHandler;

public class CapturedObject
extends AbstractContextNode {
    private String className;
    private ObjectHandler handler;
    private Map<CapturedObject, ContextNode> children = new LinkedHashMap<CapturedObject, ContextNode>();
    private CapturedObject parent;
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private Map<String, Object> additionalData = new HashMap<String, Object>();
    private StringBuilder innerXML = new StringBuilder();
    private StringBuilder script = new StringBuilder();
    private boolean inlineable = true;
    private JAXXCapture capture;

    public CapturedObject(ObjectHandler handler, String className, JAXXCapture capture) {
        this.handler = handler;
        this.className = className;
        this.capture = capture;
    }

    public ObjectHandler getObjectHandler() {
        return this.handler;
    }

    public void addChild(CapturedObject child, ContextNode constraints) {
        this.children.put(child, constraints);
        child.setParent(this);
    }

    public CapturedObject[] getChildren() {
        return this.children.keySet().toArray(new CapturedObject[this.children.size()]);
    }

    public CapturedObject getParent() {
        return this.parent;
    }

    public void setParent(CapturedObject parent) {
        this.parent = parent;
    }

    public ContextNode getConstraints(CapturedObject child) {
        return this.children.get(child);
    }

    public String getClassName() {
        return this.className;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Object getAdditionalData(String key) {
        return this.additionalData.get(key);
    }

    public void setAdditionalData(String key, Object value) {
        this.additionalData.put(key, value);
    }

    public Map<String, Object> getAdditionalData() {
        return this.additionalData;
    }

    public void setInlineable(boolean inlineable) {
        this.inlineable = inlineable;
    }

    public boolean isInlineable() {
        try {
            return this.script.length() == 0 && !Component.class.isAssignableFrom(Class.forName(this.className, true, this.capture.getClassLoader())) && this.inlineable;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void appendInnerXML(String xml) {
        if (this.innerXML.length() > 0) {
            this.innerXML.append(JAXXCompiler.getLineSeparator());
        }
        this.innerXML.append(xml);
    }

    public String getInnerXML() {
        return this.innerXML.toString();
    }

    public void appendScriptCode(String script) {
        if (this.script.length() > 0) {
            this.script.append(JAXXCompiler.getLineSeparator());
        }
        this.script.append(script);
    }

    public String getScriptCode() {
        return this.script.toString();
    }

    public String getXML(JAXXCapture capture) {
        return this.getObjectHandler().getXML(this, capture);
    }

    public String toString() {
        return "CapturedObject[" + this.getProperty("id") + ", " + this.className + "]";
    }
}

