/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: JavaFileParser.java 1873 2010-05-04 19:48:38Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2/jaxx-compiler/src/main/java/jaxx/compiler/reflect/JavaFileParser.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.reflect;

import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXFactory;
import jaxx.compiler.java.parser.JavaParser;
import jaxx.compiler.java.parser.JavaParserTreeConstants;
import jaxx.compiler.java.parser.ParseException;
import jaxx.compiler.java.parser.SimpleNode;
import jaxx.compiler.tags.TagManager;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.Reader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * @deprecated since 2.0.2, now use the {@link ClassDescriptorHelper} to obtain
 *             descriptors from java source files.
 */
@Deprecated
public class JavaFileParser {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private final Log log = LogFactory.getLog(JavaFileParser.class);

    /**
     * the compiler used (this is a dummy compiler with no link with any file).
     * <p/>
     * FIXME-TC20100504 We should remove this link : should not need of a
     * compiler to parse a java files.
     */
    private JAXXCompiler compiler;

    /** fully qualified name of the class */
    private String className;

    /** package of the class */
    private String packageName;

    /** fully qualified name of the super class or {@code null} if no super class. */
    private String superclass;

    /**
     * flag to known if we deal with an enum (the state is setted in the
     * {@link #doParse(String, Reader)} method).
     */
    private boolean isEnum;

    /**
     * flag to known if we deal with an interface(the state is setted in the
     * {@link #doParse(String, Reader)} method).
     */
    private boolean isInterface;

    /** set of fully qualified names of interfaces of the class. */
    private Set<String> interfaces;

    /** public methods of the class */
    private List<MethodDescriptor> methods;

    /** public fields of the class */
    private List<FieldDescriptor> fields;

    /** none public fields of the class */
    private List<FieldDescriptor> declaredFields;

    /**
     * If sets, compressed value of the $jaxxObjectDescriptor field, this means
     * the class if a JAXXObject implementation.
     */
    private String jaxxObjectDescriptorValue;

    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private JavaFileParser(ClassLoader classLoader) {
        //FIXME-TC-20100504 : shoudl remove this to make the parser free of jaxx :)
        // We could imagine just to offers to the parser a list of namespaces
        // (for class resolving)...
        compiler = JAXXFactory.newDummyCompiler(classLoader);
        methods = new ArrayList<MethodDescriptor>();
        interfaces = new HashSet<String>();
        fields = new ArrayList<FieldDescriptor>();
        declaredFields = new ArrayList<FieldDescriptor>();
        superclass = Object.class.getName();
    }

    public static ClassDescriptor parseJavaFile(
            String displayName,
            Reader src,
            ClassLoader classLoader) throws ClassNotFoundException {
        //FIXME-TC20091205 : no now JAXX can look to interfaces, must add them
        // has some limitations -- it reports all members as public, leaves getDeclaredMethod and getDeclaredField
        // undefined, and doesn't report interfaces.  It's safe to leave those the way they are for now, because
        // JAXX doesn't look at any of those for non-JAXX classes.
        JavaFileParser parser = new JavaFileParser(classLoader);
        if (log.isDebugEnabled()) {
            log.debug("starting parsing : " + displayName);
        }
        try {
            parser.doParse(displayName, src);
        } catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException(e);
        }

        JAXXObjectDescriptor jaxxObjectDescriptor = null;

        if (parser.jaxxObjectDescriptorValue != null) {

            // compute the jaxx object descriptor

            jaxxObjectDescriptor = JAXXUtil.decodeCompressedJAXXObjectDescriptor(
                    parser.jaxxObjectDescriptorValue
            );
        }

        List<MethodDescriptor> publicMethods = parser.methods;
        List<FieldDescriptor> publicFields = parser.fields;
        List<FieldDescriptor> declaredFields = parser.declaredFields;
        //List/*<MethodDescriptor>*/ declaredMethods = new ArrayList/*<MethodDescriptor>*/(publicMethods);
        //List/*<FieldDescriptor>*/ declaredFields = new ArrayList/*<FieldDescriptor>*/(publicFields);
        Iterator<MethodDescriptor> methods = publicMethods.iterator();
        while (methods.hasNext()) {
            MethodDescriptor method = methods.next();
            if (!Modifier.isPublic(method.getModifiers())) {
                methods.remove();
            }
        }
        Iterator<FieldDescriptor> fields = publicFields.iterator();
        while (fields.hasNext()) {
            FieldDescriptor field = fields.next();
            if (!Modifier.isPublic(field.getModifiers())) {
                fields.remove();
            }
        }

        if (parser.superclass != null) {
            //FIXME-TC20100504 This is not good, should add nothing here
            // and modify the algorithm of ClassDescriptor to go and seek
            // in super classes on interfaces if required.
            ClassDescriptor superclassDescriptor = ClassDescriptorHelper.getClassDescriptor(parser.superclass, classLoader);
            publicMethods.addAll(Arrays.asList(superclassDescriptor.getMethodDescriptors()));
            publicFields.addAll(Arrays.asList(superclassDescriptor.getFieldDescriptors()));
        }
        //FIXME-TC20091205 : now JAXX can look to interfaces, must add them
        //Set<String> interfaces = new HashSet<String>();
        //ClassDescriptor[] superclassInterfaces = superclassDescriptor.getInterfaces();
        //for (ClassDescriptor superclassInterface : superclassInterfaces) {
        //interfaces.add(superclassInterface.getName());
        //}
        String[] interfaces = parser.interfaces.toArray(new String[parser.interfaces.size()]);
        return new ClassDescriptor(parser.className,
                                   parser.packageName,
                                   parser.superclass,
                                   interfaces,
                                   parser.isInterface,
                                   false,
                                   null,
                                   jaxxObjectDescriptor,
                                   classLoader,
                                   publicMethods.toArray(new MethodDescriptor[publicMethods.size()]),
                                   publicFields.toArray(new FieldDescriptor[publicFields.size()]),
                                   declaredFields.toArray(new FieldDescriptor[declaredFields.size()])
        ) {
//                                   publicFields.toArray(new FieldDescriptor[publicFields.size()])) {

            @Override
            public FieldDescriptor getDeclaredFieldDescriptor(String name) throws NoSuchFieldException {
                for (FieldDescriptor descriptor : declaredFieldDescriptors) {
                    if (name.equals(descriptor.getName())) {
                        log.info("Using a declared field descriptor [" + name + "] for " + getName());
                        return descriptor;
                    }
                }
                throw new NoSuchFieldException(name);
            }

            @Override
            public MethodDescriptor getDeclaredMethodDescriptor(String name, ClassDescriptor... parameterTypes) throws NoSuchMethodException {
                throw new NoSuchMethodException(name);
            }
        };
    }

    private void doParse(String displayName, Reader src) {
        try {
            JavaParser p = new JavaParser(src);
            p.CompilationUnit();
            SimpleNode node = p.popNode();
            if (node != null) {
                scanCompilationUnit(node);
                return;
            }
            throw new CompilerException("Internal error: null node parsing Java file from " + src);
        } catch (ParseException e) {
            throw new CompilerException("Error parsing Java source code " + displayName + ": " + e.getMessage());
        } finally {
            if (isInterface) {

                // remove super class
                superclass = null;
            }

            if (isEnum) {

                // super class is always Enum

                superclass = Enum.class.getName();
            }
        }
    }

    private void scanCompilationUnit(SimpleNode node) {
        for (int i = 0; i < node.jjtGetNumChildren(); i++) {
            SimpleNode child = node.getChild(i);
            scanCompilationUnitChild(child);
        }
    }

    private void scanCompilationUnitChild(SimpleNode child) {
        int nodeType = child.getId();
        switch (nodeType) {
            case JavaParserTreeConstants.JJTPACKAGEDECLARATION:
                packageName = child.getChild(1).getText().trim();
                compiler.addImport(packageName + ".*");

                // add implicit java.lnag namespace available
                compiler.addImport("java.lang.*");
                break;
            case JavaParserTreeConstants.JJTIMPORTDECLARATION:
                String text = child.getText().trim();
                if (text.startsWith("import")) {
                    text = text.substring("import".length()).trim();
                }
                if (text.endsWith(";")) {
                    text = text.substring(0, text.length() - 1);
                }
                if (log.isDebugEnabled()) {
                    log.debug("import " + text);
                }
                compiler.addImport(text);
                break;
            case JavaParserTreeConstants.JJTTYPEDECLARATION:
                scanCompilationUnit(child);
                break;

            case JavaParserTreeConstants.JJTCLASSORINTERFACEDECLARATION:
                isInterface = child.firstToken.image.equals("interface");
                scanClass(child);
            case JavaParserTreeConstants.JJTENUMDECLARATION:
                isEnum = child.firstToken.image.equals("enum");
                scanClass(child);
                break;
        }
    }

    // scans the main ClassOrInterfaceDeclaration

    private void scanClass(SimpleNode node) {
//        boolean isInterface = node.firstToken.image.equals("interface");
        className = node.firstToken.next.image;
        if (packageName != null) {
            className = packageName + "." + className;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); i++) {
            SimpleNode child = node.getChild(i);
            int nodeType = child.getId();

            if (nodeType == JavaParserTreeConstants.JJTIMPLEMENTSLIST) {

                if (log.isDebugEnabled()) {
                    log.debug("[" + className + "] Found a implements list " + child + " :: " + child.jjtGetNumChildren());
                }
                // obtain interfaces
                for (int j = 0; j < child.jjtGetNumChildren(); j++) {
                    String rawName = child.getChild(j).getText().trim();

                    addInterface(rawName);
                }
                continue;
            }
            if (nodeType == JavaParserTreeConstants.JJTEXTENDSLIST) {

                if (isInterface) {

                    // obtain interfaces
                    for (int j = 0; j < child.jjtGetNumChildren(); j++) {
                        String rawName = child.getChild(j).getText().trim();

                        addInterface(rawName);
                    }
                    continue;
                }
                // this is an extends
                assert child.jjtGetNumChildren() == 1 : "expected ExtendsList to have exactly one child for a non-interface class";
                String rawName = child.getChild(0).getText().trim();
                superclass = TagManager.resolveClassName(rawName, compiler);
                if (superclass == null) {
                    throw new CompilerException("Could not find class: " + rawName);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Set superClass = " + superclass);
                }
            } else if (nodeType == JavaParserTreeConstants.JJTCLASSORINTERFACEBODY) {
                scanClassNode(child);
            }
        }
    }

    protected void addInterface(String rawName) {
        if (rawName.contains("<")) {

            // generic type
            rawName = rawName.substring(0, rawName.indexOf("<"));
        }
        if (log.isDebugEnabled()) {
            log.debug("[" + className + "]  try to obtain type of interface " + rawName);
        }

        String myInterface = resolveFullyQualifiedName(rawName);
        if (myInterface == null) {
            throw new CompilerException("Could not find interface: " + myInterface);
        }
        if (!interfaces.contains(myInterface)) {
            if (log.isDebugEnabled()) {
                log.debug("[" + className + "] add interface " + myInterface);
            }
            interfaces.add(myInterface);
        }
    }

    protected String resolveFullyQualifiedName(String rawName) {
        String result;

        String realRawName = null;
        String realParentRawName = null;
        if (rawName.contains(".")) {
            // this is a inner class
            int index = rawName.lastIndexOf(".");
            realParentRawName = rawName.substring(0, index);
            realRawName = rawName.substring(index + 1);

            log.info("inner class detected ? " + realParentRawName + "//" + realRawName);
        }

        log.info("try fqn = " + rawName);
        result = TagManager.resolveClassName(rawName, compiler);

        if (result != null) {
            // interface is detected fine (fqn was used or in good package ?)
            return result;
        }

        String suffix = "." + rawName;

        if (realParentRawName != null) {
            suffix = "." + realParentRawName;
        }

        for (String aClass : compiler.getImportedClasses()) {

            if (aClass.endsWith(suffix)) {

                // found the class as an already knwon class

                if (realRawName != null) {
                    aClass += "." + realRawName;
                }

                return aClass;
            }
        }

        // try on packages

        Set<String> importedPackages = compiler.getImportedPackages();

        for (String aClass : importedPackages) {
            String fqn = aClass + rawName;

            log.info("try fqn = " + fqn);
            result = TagManager.resolveClassName(fqn, compiler);
            if (result != null) {
                return result;
            }
        }

        // nothing was found
        return null;
    }


    // scans class body nodes

    private void scanClassNode(SimpleNode node) {
        int nodeType = node.getId();
        if (nodeType == JavaParserTreeConstants.JJTMETHODDECLARATION) {
            String returnType = null;
            String name = null;
            List<String> parameterTypes = new ArrayList<String>();
            //List<String> parameterNames = new ArrayList<String>();
            for (int i = 0; i < node.jjtGetNumChildren(); i++) {
                SimpleNode child = node.getChild(i);
                int type = child.getId();
                if (type == JavaParserTreeConstants.JJTRESULTTYPE) {
                    returnType = TagManager.resolveClassName(child.getText().trim(), compiler);
                } else if (type == JavaParserTreeConstants.JJTMETHODDECLARATOR) {
                    name = child.firstToken.image.trim();
                    SimpleNode formalParameters = child.getChild(0);
                    assert formalParameters.getId() == JavaParserTreeConstants.JJTFORMALPARAMETERS;
                    for (int j = 0; j < formalParameters.jjtGetNumChildren(); j++) {
                        SimpleNode parameter = formalParameters.getChild(j);
                        String rawParameterType = parameter.getChild(1).getText().trim().replaceAll("\\.\\.\\.", "[]");
                        String parameterType = TagManager.resolveClassName(rawParameterType, compiler);
                        if (parameterType == null && JAXXCompiler.STRICT_CHECKS) {
                            throw new CompilerException("could not find class '" + rawParameterType + "'");
                        }
                        parameterTypes.add(parameterType);
                        //parameterNames.add(parameter.getChild(2).getText().trim());
                    }
                }
            }
            methods.add(new MethodDescriptor(name, Modifier.PUBLIC, returnType, parameterTypes.toArray(new String[parameterTypes.size()]), compiler.getClassLoader())); // TODO: determine the actual modifiers
        } else if (nodeType == JavaParserTreeConstants.JJTCLASSORINTERFACEDECLARATION) {
            // TODO: handle inner classes
        } else if (nodeType == JavaParserTreeConstants.JJTCONSTRUCTORDECLARATION) {
            // TODO: handle constructors
        } else if (nodeType == JavaParserTreeConstants.JJTFIELDDECLARATION) {

            String text = node.getText();
            String declaration = text;
            String value = null;
            int equals = text.indexOf("=");
            if (equals != -1) {
                value = declaration.substring(equals + 1).trim();
                declaration = declaration.substring(0, equals);
            }
            declaration = declaration.trim();

            // get modifiers of the field

            int modifiers;
            if (isInterface) {
                modifiers = Modifier.PUBLIC | Modifier.STATIC | Modifier.FINAL;
            } else {
                modifiers = getModifiers(node);
            }

            log.info("field [" + declaration + "] modifiers == " + Modifier.toString(modifiers));

            String[] declarationTokens = declaration.split("\\s");
            String name = declarationTokens[declarationTokens.length - 1];
            if (name.endsWith(";")) {
                name = name.substring(0, name.length() - 1).trim();
            }
            String cName = declarationTokens[declarationTokens.length - 2];
            String type = TagManager.resolveClassName(cName, compiler);

            FieldDescriptor descriptor = new FieldDescriptor(
                    name,
                    modifiers,
                    type,
                    compiler.getClassLoader()
            );

            if ("$jaxxObjectDescriptor".equals(name) && value != null) {

                // we are in a jaxx object, save the value of the field

                // value have this form : = "XXX";, we just want the XXX part
                int firstIndex = value.indexOf("\"");
                int lastIndex = value.lastIndexOf("\"");

                jaxxObjectDescriptorValue = value.substring(firstIndex + 1, lastIndex);

                log.info("detected a $jaxxObjectDescriptor = " +
                         jaxxObjectDescriptorValue);

            }

            if (Modifier.isPublic(modifiers)) {
                fields.add(descriptor);
            } else {
                declaredFields.add(descriptor);
            }

        } else {
            for (int i = 0; i < node.jjtGetNumChildren(); i++) {
                SimpleNode child = node.getChild(i);
                scanClassNode(child);
            }
        }
    }

    protected int getModifiers(SimpleNode node) {
        SimpleNode parentNode = node.getParent();
        for (int i = 0; i < parentNode.jjtGetNumChildren(); i++) {
            SimpleNode child = parentNode.getChild(i);
            if (child.getId() == JavaParserTreeConstants.JJTMODIFIERS) {
                String modifiersStr = child.getText().trim();
                int modifiers = scanModifiers(modifiersStr);
                return modifiers;
            }
        }
        return 0;
    }

    protected int scanModifiers(String modifiersStr) {
        int modifiers = 0;
        if (modifiersStr.contains("public")) {
            modifiers |= Modifier.PUBLIC;
        }
        if (modifiersStr.contains("protected")) {
            modifiers |= Modifier.PROTECTED;
        }
        if (modifiersStr.contains("private")) {
            modifiers |= Modifier.PRIVATE;
        }
        if (modifiersStr.contains("static")) {
            modifiers |= Modifier.STATIC;
        }
        if (modifiersStr.contains("final")) {
            modifiers |= Modifier.FINAL;
        }
        if (modifiersStr.contains("volatile")) {
            modifiers |= Modifier.VOLATILE;
        }
        if (modifiersStr.contains("transient")) {
            modifiers |= Modifier.TRANSIENT;
        }
        if (modifiersStr.contains("synchronized")) {
            modifiers |= Modifier.SYNCHRONIZED;
        }
        if (modifiersStr.contains("abstract")) {
            modifiers |= Modifier.ABSTRACT;
        }
        return modifiers;
    }
}
