/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.decorators;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.decorators.DefaultCompiledObjectDecorator;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.runtime.swing.help.JAXXHelpUI;

public class HelpRootCompiledObjectDecorator
extends DefaultCompiledObjectDecorator {
    protected static Set<String> helpIds = new HashSet<String>();

    @Override
    public String getName() {
        return "help";
    }

    protected String getBrokerFQN(JAXXCompiler compiler) {
        String helpBrokerFQN = compiler.getConfiguration().getHelpBrokerFQN();
        return helpBrokerFQN;
    }

    protected String getHelpId(CompiledObject o) {
        String helpID = null;
        if (o.hasClientProperties()) {
            helpID = o.getClientProperty("help");
        }
        return helpID;
    }

    @Override
    public void finalizeCompiler(JAXXCompiler compiler, CompiledObject root, CompiledObject object, JavaFile javaFile, String packageName, String className, String fullClassName) {
        super.finalizeCompiler(compiler, root, object, javaFile, packageName, className, fullClassName);
        CompilerConfiguration options = compiler.getConfiguration();
        if (options.isGenerateHelp()) {
            Class<JAXXHelpUI> validatorInterface = JAXXHelpUI.class;
            String helpBrokerFQN = this.getBrokerFQN(compiler);
            javaFile.addInterface(JAXXCompiler.getCanonicalName(validatorInterface) + "<" + helpBrokerFQN + ">");
            javaFile.addMethod(JavaFileGenerator.newMethod(1, "void", "registerHelpId", "broker.installUI(component, helpId);", true, new JavaArgument(helpBrokerFQN, "broker"), new JavaArgument("Component", "component"), new JavaArgument("String", "helpId")));
            javaFile.addMethod(JavaFileGenerator.newMethod(1, "void", "showHelp", "getBroker().showHelp(this, helpId);", true, new JavaArgument("String", "helpId")));
            StringBuilder buffer = new StringBuilder();
            String eol = JAXXCompiler.getLineSeparator();
            Iterator<CompiledObject> itr = compiler.getObjectCreationOrder();
            while (itr.hasNext()) {
                CompiledObject o = itr.next();
                String helpID = this.getHelpId(o);
                if (helpID == null) continue;
                buffer.append(eol);
                buffer.append("registerHelpId(_broker, ");
                buffer.append(o.getJavaCode());
                buffer.append(", ");
                buffer.append(helpID);
                buffer.append(");");
                helpIds.add(helpID);
            }
            if (buffer.length() > 0) {
                StringBuilder extraCode = new StringBuilder(helpBrokerFQN);
                extraCode.append(" _broker = getBroker();");
                buffer.append(eol).append("_broker.prepareUI(this);");
                buffer.append(eol);
                compiler.appendLateInitializer("// help broker setup" + eol);
                compiler.appendLateInitializer(extraCode.toString());
                compiler.appendLateInitializer(buffer.toString());
            }
        }
    }

    public static Set<String> getHelpIds() {
        return new HashSet<String>(helpIds);
    }
}

