/*
 * Decompiled with CFR 0.152.
 */
package jaxx.types;

import java.util.HashMap;
import java.util.Map;
import jaxx.types.TypeConverter;

public class TypeManager {
    private static Map<Class, TypeConverter> converters = new HashMap<Class, TypeConverter>();

    private TypeManager() {
    }

    public static void registerTypeConverter(Class type, TypeConverter converter) {
        converters.put(type, converter);
    }

    public static TypeConverter getTypeConverter(Class type) {
        return converters.get(type);
    }

    public static String getJavaCode(Object object) {
        if (object == null) {
            return "null";
        }
        TypeConverter converter = TypeManager.getTypeConverter(object.getClass());
        if (converter == null) {
            throw new IllegalArgumentException("unsupported type: " + object.getClass());
        }
        return converter.getJavaCode(object);
    }

    public static Object convertFromString(String string, Class type) {
        TypeConverter converter = TypeManager.getTypeConverter(type);
        if (converter == null) {
            throw new IllegalArgumentException("unsupported type: " + type);
        }
        return converter.convertFromString(string, type);
    }
}

