/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import jaxx.compiler.JavaArgument;
import jaxx.compiler.JavaField;
import jaxx.compiler.JavaMethod;
import org.apache.commons.lang.StringUtils;

public class JavaFile {
    protected static final String GETTER_PATTERN = "return %1$s;";
    protected static final String BOOLEAN_GETTER_PATTERN = "return %1$s !=null && %1$s;";
    protected static final String SETTER_PATTERN = "%1$s oldValue = this.%2$s;\nthis.%2$s = newValue;\nfirePropertyChange(\"%2$s\", oldValue, newValue);";
    private int modifiers;
    private String className;
    private List<String> imports = new ArrayList<String>();
    private List<JavaField> fields = new ArrayList<JavaField>();
    private List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private List<JavaFile> innerClasses = new ArrayList<JavaFile>();
    private String superClass;
    private List<String> interfaces;
    private StringBuffer rawBodyCode = new StringBuffer();
    private boolean superclassIsJAXXObject;
    private boolean abstractClass;
    private String genericType;
    private String superGenericType;

    public JavaFile() {
    }

    public JavaFile(int modifiers, String className, String superClass) {
        this(modifiers, className, superClass, null);
    }

    public JavaFile(int modifiers, String className, String superClass, List<String> interfaces) {
        this.modifiers = modifiers;
        this.className = className;
        this.superClass = superClass;
        this.interfaces = interfaces;
    }

    public void addImport(String importString) {
        this.imports.add(importString);
    }

    public void addImport(Class importString) {
        this.imports.add(importString.getName());
    }

    public String[] getImports() {
        return this.imports.toArray(new String[this.imports.size()]);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public List<String> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<String>();
        }
        return this.interfaces;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public void setGenericType(String genericType) {
        this.genericType = genericType;
    }

    public void addMethod(JavaMethod method) {
        this.methods.add(method);
    }

    public JavaMethod[] getMethods() {
        return this.methods.toArray(new JavaMethod[this.methods.size()]);
    }

    public void addField(JavaField field) {
        this.addField(field, false);
    }

    public void addField(JavaField field, boolean javaBean) {
        this.addSimpleField(field);
        String id = field.getName();
        String capitalizedName = StringUtils.capitalize((String)id);
        String content = String.format(GETTER_PATTERN, id);
        this.addMethod(new JavaMethod(Modifier.isProtected(field.getModifiers()) ? 1 : 4, field.getType(), "get" + capitalizedName, null, null, content));
        if (javaBean) {
            if (Boolean.class.getName().equals(field.getType())) {
                content = String.format(BOOLEAN_GETTER_PATTERN, id);
                this.addMethod(new JavaMethod(1, field.getType(), "is" + capitalizedName, null, null, content));
            }
            content = String.format(SETTER_PATTERN, field.getType(), id);
            JavaArgument arg = new JavaArgument(field.getType(), "newValue");
            this.addMethod(new JavaMethod(1, "void", "set" + capitalizedName, new JavaArgument[]{arg}, null, content));
        }
    }

    public void addSimpleField(JavaField field) {
        this.fields.add(field);
    }

    public JavaField[] getFields() {
        return this.fields.toArray(new JavaField[this.fields.size()]);
    }

    public static String addIndentation(String source, int indentation, String lineSeparator) {
        return JavaFile.indent(source, indentation, false, lineSeparator);
    }

    public static String setIndentation(String source, int indentation, String lineSeparator) {
        return JavaFile.indent(source, indentation, true, lineSeparator);
    }

    public static String indent(String source, int indentation, boolean trim, String lineSeparator) {
        if (trim) {
            source = source.trim();
        }
        char[] spaces = new char[indentation];
        Arrays.fill(spaces, ' ');
        StringBuffer result = new StringBuffer();
        String[] lines = source.split(System.getProperty("line.separator") + "|\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append(lineSeparator);
            }
            result.append(spaces);
            result.append(trim ? lines[i].trim() : lines[i]);
        }
        return result.toString();
    }

    public void addBodyCode(String bodyCode) {
        this.rawBodyCode.append(bodyCode);
    }

    public String getClassBody(String lineSeparator) {
        StringBuffer result = new StringBuffer();
        if (this.fields.size() > 0) {
            Collections.sort(this.fields);
            for (JavaField field : this.fields) {
                result.append(JavaFile.addIndentation(field.toString(lineSeparator), 4, lineSeparator));
                result.append(lineSeparator);
            }
            result.append(lineSeparator);
        }
        if (this.rawBodyCode.length() > 0) {
            result.append(JavaFile.addIndentation("/* begin raw body code */\n", 4, lineSeparator));
            String s = this.rawBodyCode.toString();
            if (!s.startsWith(lineSeparator)) {
                result.append(lineSeparator);
            }
            result.append(JavaFile.addIndentation(s, 4, lineSeparator));
            result.append(lineSeparator);
            result.append(JavaFile.addIndentation("/* end raw body code */", 4, lineSeparator));
            result.append(lineSeparator);
        }
        for (JavaFile innerClass : this.innerClasses) {
            result.append(JavaFile.addIndentation(innerClass.toString(), 4, lineSeparator));
            result.append(lineSeparator).append(lineSeparator);
        }
        EnumMap<JavaMethod.MethodOrder, List<JavaMethod>> map = JavaMethod.getSortedMethods(this.methods);
        for (Map.Entry<JavaMethod.MethodOrder, List<JavaMethod>> entry : map.entrySet()) {
            List<JavaMethod> list = entry.getValue();
            entry.getKey().generate(result, list, lineSeparator);
            list.clear();
        }
        map.clear();
        return result.toString();
    }

    public String getClassDefinition(String lineSeparator) {
        StringBuffer result = new StringBuffer();
        result.append(JavaFile.getModifiersText(this.modifiers));
        if (this.abstractClass) {
            result.append("abstract ");
        }
        result.append("class ");
        result.append(this.className.substring(this.className.lastIndexOf(".") + 1));
        if (this.genericType != null) {
            result.append('<').append(this.genericType).append('>');
        }
        result.append(" extends ");
        result.append(this.superClass);
        if (this.superGenericType != null) {
            result.append('<').append(this.superGenericType).append('>');
        }
        if (this.interfaces != null && !this.interfaces.isEmpty()) {
            result.append(" implements ").append(this.interfaces.get(0));
            for (int i = 1; i < this.interfaces.size(); ++i) {
                result.append(", ").append(this.interfaces.get(i));
            }
        }
        result.append(" {");
        result.append(lineSeparator);
        result.append(this.getClassBody(lineSeparator));
        result.append("}");
        return result.toString();
    }

    public static String getModifiersText(int modifiers) {
        if (modifiers == 0) {
            return "";
        }
        return Modifier.toString(modifiers) + ' ';
    }

    public String toString(String lineSeparator) {
        StringBuffer result = new StringBuffer();
        if (this.className.indexOf(".") != -1) {
            result.append("package ").append(this.className.substring(0, this.className.lastIndexOf("."))).append(";");
            result.append(lineSeparator);
            result.append(lineSeparator);
        }
        if (this.imports.size() > 0) {
            for (String anImport : this.imports) {
                result.append("import ");
                result.append(anImport);
                result.append(';');
                result.append(lineSeparator);
            }
            result.append(lineSeparator);
        }
        result.append(this.getClassDefinition(lineSeparator));
        return result.toString();
    }

    public void addInterface(String canonicalName) {
        if (this.interfaces == null || !this.interfaces.contains(canonicalName)) {
            this.getInterfaces().add(canonicalName);
        }
    }

    public void addInterfaces(String[] canonicalNames) {
        if (canonicalNames == null) {
            return;
        }
        for (String canonicalName : canonicalNames) {
            if (this.interfaces != null && this.interfaces.contains(canonicalName)) continue;
            this.getInterfaces().add(canonicalName);
        }
    }

    public boolean isSuperclassIsJAXXObject() {
        return this.superclassIsJAXXObject;
    }

    public void setSuperclassIsJAXXObject(boolean superclassIsJAXXObject) {
        this.superclassIsJAXXObject = superclassIsJAXXObject;
    }

    public void setAbstractClass(boolean abstractClass) {
        this.abstractClass = abstractClass;
    }

    public void setSuperGenericType(String superGenericType) {
        this.superGenericType = superGenericType;
    }
}

