/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jaxx.Base64Coder;
import jaxx.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.DataBinding;
import jaxx.compiler.EventHandler;
import jaxx.compiler.Generator;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JavaArgument;
import jaxx.compiler.JavaField;
import jaxx.compiler.JavaFile;
import jaxx.compiler.JavaMethod;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.reflect.FieldDescriptor;
import jaxx.reflect.MemberDescriptor;
import jaxx.reflect.MethodDescriptor;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.types.TypeManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXXObjectGenerator
implements Generator {
    protected static final Log log = LogFactory.getLog(JAXXObjectGenerator.class);
    protected static final JavaField ACTIVE_BINDINGS_FIELD = JavaField.newField(4, "java.util.List<Object>", "$activeBindings", "new ArrayList<Object>()");
    protected static final JavaField BINDING_SOURCES_FIELD = JavaField.newField(4, "java.util.Map<String,Object>", "$bindingSources", "new HashMap<String,Object>()");
    protected static final JavaField OBJECT_MAP_FIELD = JavaField.newField(4, "Map<String,Object>", "$objectMap", "new HashMap<String,Object>()");
    protected static final JavaField ALL_COMPONENTS_CREATED_FIELD = JavaField.newField(2, "boolean", "allComponentsCreated");
    protected static final JavaField CONTEXT_INITIALIZED = JavaField.newField(2, "boolean", "contextInitialized", "true");
    protected static final JavaField PREVIOUS_VALUES_FIELD = JavaField.newField(0, "java.util.Map", "$previousValues", "new java.util.HashMap()");
    protected static final JavaField DELEGATE_CONTEXT_FIELD = JavaField.newField(4, "jaxx.runtime.JAXXContext", "delegateContext");
    protected static final JavaField PROPERTY_CHANGE_SUPPORT_FIELD = JavaField.newField(0, "java.beans.PropertyChangeSupport", "$propertyChangeSupport");
    protected static final JavaMethod GET_CONTEXT_VALUE_METHOD = JavaMethod.newMethod(1, "<T> T", "getContextValue", "return delegateContext.getContextValue(clazz, null);", new JavaArgument("Class<T>", "clazz"));
    protected static final JavaMethod GET_CONTEXT_VALUE_NAMED_METHOD = JavaMethod.newMethod(1, "<T> T", "getContextValue", "return delegateContext.getContextValue(clazz, name);", new JavaArgument("Class<T>", "clazz"), new JavaArgument("String", "name"));
    protected static final JavaMethod SET_CONTEXT_VALUE_NAMED_METHOD = JavaMethod.newMethod(1, "<T> void", "setContextValue", "delegateContext.setContextValue(o, name);", new JavaArgument("T", "o"), new JavaArgument("String", "name"));
    protected static final JavaMethod SET_CONTEXT_VALUE_METHOD = JavaMethod.newMethod(1, "<T> void", "setContextValue", "delegateContext.setContextValue(o, null);", new JavaArgument("T", "o"));
    protected static final JavaMethod REMOVE_CONTEXT_VALUE_NAMED_METHOD = JavaMethod.newMethod(1, "<T> void", "removeContextValue", "delegateContext.removeContextValue(clazz, name);", new JavaArgument("Class<T>", "clazz"), new JavaArgument("String", "name"));
    protected static final JavaMethod REMOVE_CONTEXT_VALUE_METHOD = JavaMethod.newMethod(1, "<T> void", "removeContextValue", "delegateContext.removeContextValue(clazz, null);", new JavaArgument("Class<T>", "clazz"));
    protected static final JavaMethod GET_PARENT_CONTAINER_MORE_METHOD = JavaMethod.newMethod(1, "<O extends Container> O", "getParentContainer", "return delegateContext.getParentContainer(source, clazz);", new JavaArgument("Object", "source"), new JavaArgument("Class<O>", "clazz"));
    protected static final JavaMethod GET_PARENT_CONTAINER_METHOD = JavaMethod.newMethod(1, "<O extends Container> O", "getParentContainer", "return delegateContext.getParentContainer(clazz);", new JavaArgument("Class<O>", "clazz"));
    protected static final JavaMethod GET_OBJECT_BY_ID_METHOD = JavaMethod.newMethod(1, "java.lang.Object", "getObjectById", "return $objectMap.get(id);", new JavaArgument("String", "id"));
    protected static final JavaMethod GET_JAXX_OBJECT_DESCRIPTOR_METHOD = JavaMethod.newMethod(9, "jaxx.runtime.JAXXObjectDescriptor", "$getJAXXObjectDescriptor", "return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);", new JavaArgument[0]);
    protected static final JavaMethod PROCESS_DATA_BINDING_METHOD = JavaMethod.newMethod(1, "void", "processDataBinding", "processDataBinding(dest, false);", new JavaArgument("String", "dest"));
    protected static final JavaMethod FIRE_PROPERTY_CHANGE_METHOD = JavaMethod.newMethod(1, "void", "firePropertyChange", "super.firePropertyChange(propertyName, oldValue, newValue);", new JavaArgument("String", "propertyName"), new JavaArgument("Object", "oldValue"), new JavaArgument("Object", "newValue"));
    protected static final JavaMethod FIRE_PROPERTY_CHANGE_NAMED_METHOD = JavaMethod.newMethod(1, "void", "firePropertyChange", "$getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);", new JavaArgument("String", "propertyName"), new JavaArgument("Object", "oldValue"), new JavaArgument("Object", "newValue"));
    protected static final JavaMethod GET_PROPERTY_CHANGE_SUPPORT_METHOD = JavaMethod.newMethod(0, "java.beans.PropertyChangeSupport", "$getPropertyChangeSupport", "if ($propertyChangeSupport == null)\n    $propertyChangeSupport = new PropertyChangeSupport(this);\nreturn $propertyChangeSupport;", new JavaArgument[0]);
    protected static final JavaMethod ADD_PROPERTY_CHANGE_SUPPORT_METHOD = JavaMethod.newMethod(1, "void", "addPropertyChangeListener", "$getPropertyChangeSupport().addPropertyChangeListener(listener);", new JavaArgument("java.beans.PropertyChangeListener", "listener"));
    protected static final JavaMethod ADD_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD = JavaMethod.newMethod(1, "void", "addPropertyChangeListener", "$getPropertyChangeSupport().addPropertyChangeListener(property, listener);", new JavaArgument("String", "property"), new JavaArgument("java.beans.PropertyChangeListener", "listener"));
    protected static final JavaMethod REMOVE_PROPERTY_CHANGE_SUPPORT_METHOD = JavaMethod.newMethod(1, "void", "removePropertyChangeListener", "$getPropertyChangeSupport().removePropertyChangeListener(listener);", new JavaArgument("java.beans.PropertyChangeListener", "listener"));
    protected static final JavaMethod REMOVE_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD = JavaMethod.newMethod(1, "void", "removePropertyChangeListener", "$getPropertyChangeSupport().removePropertyChangeListener(property, listener);", new JavaArgument("String", "property"), new JavaArgument("java.beans.PropertyChangeListener", "listener"));

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        String fullClassName;
        String string = fullClassName = packageName != null ? packageName + "." + className : className;
        if (root == null) {
            throw new CompilerException("root tag must be a class tag");
        }
        ClassDescriptor superclass = root.getObjectClass();
        boolean superclassIsJAXXObject = ClassDescriptorLoader.getClassDescriptor(JAXXObject.class).isAssignableFrom(superclass);
        javaFile.setModifiers(1);
        javaFile.setClassName(fullClassName);
        javaFile.setSuperClass(JAXXCompiler.getCanonicalName(superclass));
        javaFile.setSuperclassIsJAXXObject(superclassIsJAXXObject);
        javaFile.addInterfaces(compiler.getExtraInterfaces());
        javaFile.setAbstractClass(compiler.isAbstractClass());
        javaFile.setGenericType(compiler.getGenericType());
        javaFile.setSuperGenericType(compiler.getSuperGenericType());
        for (CompiledObject object : compiler.getObjects().values()) {
            CompiledObjectDecorator decorator = object.getDecorator();
            decorator.finalizeCompiler(compiler, root, object, javaFile, packageName, className, fullClassName);
        }
        for (DataBinding dataBinding : compiler.getDataBindings()) {
            if (!dataBinding.compile(true)) continue;
            compiler.getInitDataBindings().append("applyDataBinding(").append(TypeManager.getJavaCode(dataBinding.getId())).append(");").append(JAXXCompiler.getLineSeparator());
        }
        if (superclassIsJAXXObject) {
            boolean hasBind;
            boolean bl = hasBind = compiler.getApplyDataBinding().length() > 0;
            if (hasBind) {
                compiler.appendApplyDataBinding(" else {");
                compiler.appendApplyDataBinding(JAXXCompiler.getLineSeparator());
                compiler.appendApplyDataBinding("    ");
            }
            compiler.appendApplyDataBinding("super.applyDataBinding($binding);");
            compiler.appendApplyDataBinding(JAXXCompiler.getLineSeparator());
            if (hasBind) {
                compiler.appendApplyDataBinding("    return;");
                compiler.appendApplyDataBinding(JAXXCompiler.getLineSeparator());
                compiler.appendApplyDataBinding("}");
            }
            boolean bl2 = hasBind = compiler.getRemoveDataBinding().length() > 0;
            if (hasBind) {
                compiler.appendRemoveDataBinding(" else {");
                compiler.appendRemoveDataBinding(JAXXCompiler.getLineSeparator());
                compiler.appendRemoveDataBinding("    ");
            }
            compiler.appendRemoveDataBinding("super.removeDataBinding($binding);");
            compiler.appendRemoveDataBinding(JAXXCompiler.getLineSeparator());
            if (hasBind) {
                compiler.appendRemoveDataBinding("}");
            }
        } else {
            javaFile.addInterface(JAXXCompiler.getCanonicalName(JAXXObject.class));
        }
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {
        MethodDescriptor[] methods;
        FieldDescriptor[] scriptFields;
        String fullClassName = javaFile.getClassName();
        String jaxxContextImplementorClass = compiler.getOptions().getJaxxContextImplementorClass();
        boolean superclassIsJAXXObject = javaFile.isSuperclassIsJAXXObject();
        if (!superclassIsJAXXObject) {
            if (compiler.getOptions().isAddLogger()) {
                javaFile.addImport(Log.class);
                javaFile.addImport(LogFactory.class);
                javaFile.addField(JavaField.newField(25, "Log", "log", "LogFactory.getLog(" + fullClassName + ".class)"));
            }
            javaFile.addField(OBJECT_MAP_FIELD);
            javaFile.addMethod(GET_OBJECT_BY_ID_METHOD);
            javaFile.addField(BINDING_SOURCES_FIELD);
            javaFile.addField(ACTIVE_BINDINGS_FIELD);
            javaFile.addField(JavaField.newField(20, JAXXContext.class.getName(), "delegateContext", "new " + jaxxContextImplementorClass + "(this);"));
            javaFile.addMethod(SET_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(SET_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(GET_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(GET_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(REMOVE_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(REMOVE_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(GET_PARENT_CONTAINER_METHOD);
            javaFile.addMethod(GET_PARENT_CONTAINER_MORE_METHOD);
            this.addPropertyChangeSupport(root, javaFile);
            javaFile.addMethod(PROCESS_DATA_BINDING_METHOD);
        }
        javaFile.addField(ALL_COMPONENTS_CREATED_FIELD);
        boolean overrideContextInitialized = false;
        for (FieldDescriptor f : scriptFields = compiler.getScriptFields()) {
            if (!"contextInitialized".equals(f.getName())) continue;
            overrideContextInitialized = true;
            break;
        }
        if (!overrideContextInitialized) {
            javaFile.addField(CONTEXT_INITIALIZED);
        }
        javaFile.addField(this.createJAXXObjectDescriptorField(compiler, javaFile));
        if (compiler.getStylesheet() != null) {
            javaFile.addField(PREVIOUS_VALUES_FIELD);
        }
        boolean constructorDetected = false;
        for (MethodDescriptor m : methods = compiler.getScriptMethods()) {
            try {
                m.getReturnType();
                if (!className.equals(m.getName())) continue;
                constructorDetected = true;
                break;
            }
            catch (Exception e) {
                log.warn((Object)("could not find return type " + m));
            }
        }
        if (!constructorDetected) {
            javaFile.addMethod(this.createConstructor(compiler, className, superclassIsJAXXObject));
            javaFile.addMethod(this.createConstructorWithInitialContext(compiler, className, superclassIsJAXXObject));
        }
        javaFile.addMethod(this.createInitializer(compiler));
        javaFile.addMethod(GET_JAXX_OBJECT_DESCRIPTOR_METHOD);
        javaFile.addBodyCode(compiler.getBodyCode().toString());
        javaFile.addMethod(this.createCompleteSetupMethod(compiler, javaFile, compiler.getInitDataBindings()));
        javaFile.addMethod(JavaMethod.newMethod(1, "void", "applyDataBinding", compiler.getApplyDataBinding().toString() + JAXXCompiler.getLineSeparator() + "processDataBinding($binding);", new JavaArgument("String", "$binding")));
        javaFile.addMethod(JavaMethod.newMethod(1, "void", "removeDataBinding", compiler.getRemoveDataBinding().toString(), new JavaArgument("String", "$binding")));
        javaFile.addMethod(this.createProcessDataBindingMethod(compiler, superclassIsJAXXObject));
        this.addEventHandlers(compiler, javaFile);
    }

    protected JavaField createJAXXObjectDescriptorField(JAXXCompiler compiler, JavaFile javaFile) {
        try {
            JAXXObjectDescriptor descriptor = compiler.getJAXXObjectDescriptor();
            String data = Base64Coder.serialize((Object)descriptor, (boolean)true);
            int sizeLimit = 65000;
            if (data.length() < sizeLimit) {
                return JavaField.newField(10, "java.lang.String", "$jaxxObjectDescriptor", TypeManager.getJavaCode(data));
            }
            StringBuffer initializer = new StringBuffer();
            for (int i = 0; i < data.length(); i += sizeLimit) {
                String name = "$jaxxObjectDescriptor" + i;
                javaFile.addField(new JavaField(10, "java.lang.String", name, TypeManager.getJavaCode(data.substring(i, Math.min(i + sizeLimit, data.length())))));
                if (initializer.length() > 0) {
                    initializer.append(" + ");
                }
                initializer.append("String.valueOf(").append(name).append(")");
            }
            return JavaField.newField(10, "java.lang.String", "$jaxxObjectDescriptor", initializer.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
    }

    protected void addPropertyChangeSupport(CompiledObject root, JavaFile javaFile) {
        int modifiers;
        ClassDescriptor currentClass = root.getObjectClass();
        MemberDescriptor firePropertyChange = null;
        while (firePropertyChange == null && currentClass != null) {
            try {
                firePropertyChange = currentClass.getDeclaredMethodDescriptor("firePropertyChange", ClassDescriptorLoader.getClassDescriptor(String.class), ClassDescriptorLoader.getClassDescriptor(Object.class), ClassDescriptorLoader.getClassDescriptor(Object.class));
            }
            catch (NoSuchMethodException e) {
                currentClass = currentClass.getSuperclass();
            }
        }
        int n = modifiers = firePropertyChange != null ? firePropertyChange.getModifiers() : 0;
        if (Modifier.isPublic(modifiers)) {
            // empty if block
        }
        if (Modifier.isProtected(modifiers)) {
            javaFile.addMethod(FIRE_PROPERTY_CHANGE_METHOD);
        } else {
            javaFile.addField(PROPERTY_CHANGE_SUPPORT_FIELD);
            javaFile.addMethod(GET_PROPERTY_CHANGE_SUPPORT_METHOD);
            javaFile.addMethod(ADD_PROPERTY_CHANGE_SUPPORT_METHOD);
            javaFile.addMethod(ADD_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD);
            javaFile.addMethod(REMOVE_PROPERTY_CHANGE_SUPPORT_METHOD);
            javaFile.addMethod(REMOVE_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD);
            javaFile.addMethod(FIRE_PROPERTY_CHANGE_NAMED_METHOD);
        }
    }

    protected void addEventHandlers(JAXXCompiler compiler, JavaFile javaFile) {
        for (Map.Entry<String, Map<ClassDescriptor, List<EventHandler>>> e1 : compiler.getEventHandlers().entrySet()) {
            for (Map.Entry<ClassDescriptor, List<EventHandler>> e2 : e1.getValue().entrySet()) {
                for (EventHandler handler : e2.getValue()) {
                    String methodName = compiler.getEventHandlerMethodName(handler);
                    MethodDescriptor listenerMethod = handler.getListenerMethod();
                    if (listenerMethod.getParameterTypes().length != 1) {
                        throw new CompilerException("Expected event handler " + listenerMethod.getName() + " of class " + handler.getListenerClass() + " to have exactly one argument");
                    }
                    javaFile.addMethod(JavaMethod.newMethod(1, "void", methodName, handler.getJavaCode(), new JavaArgument(JAXXCompiler.getCanonicalName(listenerMethod.getParameterTypes()[0]), "event")));
                }
            }
        }
    }

    protected JavaMethod createConstructor(JAXXCompiler compiler, String className, boolean superclassIsJAXXObject) throws CompilerException {
        StringBuffer code = new StringBuffer();
        String constructorParams = compiler.getRootObject().getConstructorParams();
        if (constructorParams != null) {
            code.append("        super(").append(constructorParams).append(");").append(JAXXCompiler.getLineSeparator());
        } else if (superclassIsJAXXObject) {
            code.append("        super();").append(JAXXCompiler.getLineSeparator());
        }
        code.append("$initialize();");
        code.append(JAXXCompiler.getLineSeparator());
        return JavaMethod.newMethod(1, null, className, code.toString(), new JavaArgument[0]);
    }

    protected JavaMethod createConstructorWithInitialContext(JAXXCompiler compiler, String className, boolean superclassIsJAXXObject) throws CompilerException {
        StringBuffer code = new StringBuffer();
        String constructorParams = compiler.getRootObject().getConstructorParams();
        if (constructorParams != null) {
            code.append("        super(").append(constructorParams).append(");").append(JAXXCompiler.getLineSeparator());
        } else if (superclassIsJAXXObject) {
            code.append("        super(parentContext);").append(JAXXCompiler.getLineSeparator());
        }
        if (!superclassIsJAXXObject) {
            code.append("if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {");
            code.append(JAXXCompiler.getLineSeparator());
            code.append("    ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);");
            code.append(JAXXCompiler.getLineSeparator());
            code.append("} else {");
            code.append(JAXXCompiler.getLineSeparator());
            code.append("    setContextValue(parentContext);");
            code.append(JAXXCompiler.getLineSeparator());
            code.append("}");
            code.append(JAXXCompiler.getLineSeparator());
        }
        code.append("$initialize();");
        code.append(JAXXCompiler.getLineSeparator());
        return JavaMethod.newMethod(1, null, className, code.toString(), new JavaArgument("jaxx.runtime.JAXXContext", "parentContext"));
    }

    public JavaMethod createInitializer(JAXXCompiler compiler) throws CompilerException {
        StringBuffer code = new StringBuffer();
        CompiledObject root = compiler.getRootObject();
        code.append("if (allComponentsCreated || !contextInitialized) {");
        code.append(JAXXCompiler.getLineSeparator());
        code.append("    return;");
        code.append(JAXXCompiler.getLineSeparator());
        code.append("}");
        code.append(JAXXCompiler.getLineSeparator());
        code.append("$objectMap.put(").append(TypeManager.getJavaCode(root.getId())).append(", this);");
        code.append(JAXXCompiler.getLineSeparator());
        Iterator<CompiledObject> i = compiler.getObjectCreationOrder();
        boolean lastWasMethodCall = false;
        while (i.hasNext()) {
            CompiledObject object = i.next();
            if (object == root) continue;
            CompiledObjectDecorator decorator = object.getDecorator();
            lastWasMethodCall = decorator.createInitializer(compiler, root, object, code, lastWasMethodCall);
        }
        root.getDecorator().createInitializer(compiler, root, root, code, lastWasMethodCall);
        code.append(JAXXCompiler.getLineSeparator());
        if (compiler.getInitializer().length() > 0) {
            code.append(compiler.getInitializer());
            code.append(JAXXCompiler.getLineSeparator());
        }
        code.append("$completeSetup();");
        code.append(JAXXCompiler.getLineSeparator());
        return JavaMethod.newMethod(2, "void", "$initialize", code.toString(), new JavaArgument[0]);
    }

    protected JavaMethod createCompleteSetupMethod(JAXXCompiler compiler, JavaFile javaFile, StringBuffer initDataBindings) {
        MethodDescriptor method;
        StringBuffer code = new StringBuffer();
        code.append("allComponentsCreated = true;");
        code.append(JAXXCompiler.getLineSeparator());
        for (CompiledObject object : compiler.getObjects().values()) {
            CompiledObjectDecorator decorator = object.getDecorator();
            code.append(decorator.createCompleteSetupMethod(compiler, object, javaFile, initDataBindings));
        }
        code.append(initDataBindings);
        if (compiler.getLateInitializer().length() > 0) {
            code.append(compiler.getLateInitializer());
            code.append(JAXXCompiler.getLineSeparator());
        }
        if ((method = compiler.getScriptMethod("$afterCompleteSetup")) != null) {
            code.append("$afterCompleteSetup();").append(JAXXCompiler.getLineSeparator());
        }
        return JavaMethod.newMethod(2, "void", "$completeSetup", code.toString(), new JavaArgument[0]);
    }

    protected JavaMethod createProcessDataBindingMethod(JAXXCompiler compiler, boolean superclassIsJAXXObject) {
        StringBuffer code = new StringBuffer();
        if (compiler.getProcessDataBinding().length() > 0) {
            code.append("    if (!$force && $activeBindings.contains($dest)) { ");
            code.append(JAXXCompiler.getLineSeparator());
            code.append("    return;");
            code.append(JAXXCompiler.getLineSeparator());
            code.append("}");
            code.append(JAXXCompiler.getLineSeparator());
            code.append("$activeBindings.add($dest);");
            code.append(JAXXCompiler.getLineSeparator());
            code.append("try {");
            code.append(JAXXCompiler.getLineSeparator());
            if (compiler.getProcessDataBinding().length() > 0) {
                code.append(compiler.getProcessDataBinding().toString());
            }
            if (superclassIsJAXXObject) {
                code.append(" else {");
                code.append(JAXXCompiler.getLineSeparator());
                code.append("        super.processDataBinding($dest, true);");
                code.append(JAXXCompiler.getLineSeparator());
                code.append("    }");
                code.append(JAXXCompiler.getLineSeparator());
            }
            code.append("} finally {");
            code.append(JAXXCompiler.getLineSeparator());
            code.append("    $activeBindings.remove($dest);");
            code.append(JAXXCompiler.getLineSeparator());
            code.append("}");
            code.append(JAXXCompiler.getLineSeparator());
        } else if (superclassIsJAXXObject) {
            code.append("super.processDataBinding($dest, true);");
            code.append(JAXXCompiler.getLineSeparator());
        }
        return JavaMethod.newMethod(1, "void", "processDataBinding", code.toString(), new JavaArgument("String", "$dest"), new JavaArgument("boolean", "$force"));
    }
}

