/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerOptions;
import jaxx.compiler.DefaultCompiledObjectDecorator;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JavaArgument;
import jaxx.compiler.JavaFile;
import jaxx.compiler.JavaMethod;
import jaxx.runtime.JaxxHelpUI;

public class HelpRootCompiledObjectDecorator
extends DefaultCompiledObjectDecorator {
    protected static Set<String> helpIds = new HashSet<String>();

    protected String getBrokerFQN(JAXXCompiler compiler) {
        String helpBrokerFQN = compiler.getOptions().getHelpBrokerFQN();
        return helpBrokerFQN;
    }

    protected String getHelpId(CompiledObject o) {
        String helpID = null;
        if (o.hasClientProperties()) {
            helpID = o.getClientProperty("help");
        }
        return helpID;
    }

    @Override
    public void finalizeCompiler(JAXXCompiler compiler, CompiledObject root, CompiledObject object, JavaFile javaFile, String packageName, String className, String fullClassName) {
        super.finalizeCompiler(compiler, root, object, javaFile, packageName, className, fullClassName);
        CompilerOptions options = compiler.getOptions();
        if (options.isGenerateHelp()) {
            Class<JaxxHelpUI> validatorInterface = JaxxHelpUI.class;
            String helpBrokerFQN = this.getBrokerFQN(compiler);
            javaFile.addInterface(JAXXCompiler.getCanonicalName(validatorInterface) + "<" + helpBrokerFQN + ">");
            javaFile.addMethod(JavaMethod.newMethod(1, "void", "registerHelpId", "broker.installUI(component, helpId);", new JavaArgument(helpBrokerFQN, "broker"), new JavaArgument("Component", "component"), new JavaArgument("String", "helpId")));
            javaFile.addMethod(JavaMethod.newMethod(1, "void", "showHelp", "getBroker().showHelp(this, helpId);", new JavaArgument("String", "helpId")));
            StringBuilder buffer = new StringBuilder();
            String lineSeparator = JAXXCompiler.getLineSeparator();
            if (options.isGenerateHelp()) {
                Iterator<CompiledObject> itr = compiler.getObjectCreationOrder();
                while (itr.hasNext()) {
                    CompiledObject o = itr.next();
                    String helpID = this.getHelpId(o);
                    if (helpID == null) continue;
                    buffer.append(lineSeparator);
                    buffer.append("registerHelpId(_broker, " + o.getJavaCode() + ", " + helpID + ");");
                    helpIds.add(helpID);
                }
            }
            if (buffer.length() > 0) {
                StringBuilder extraCode = new StringBuilder(helpBrokerFQN).append(" _broker = getBroker();");
                buffer.append(lineSeparator).append("_broker.prepareUI(this);");
                buffer.append(lineSeparator);
                compiler.appendLateInitializer(extraCode.toString());
                compiler.appendLateInitializer(buffer.toString());
            }
        }
    }

    public static Set<String> getHelpIds() {
        return helpIds;
    }
}

