package org.nuiton.jaxx.application.swing.tab;

/*
 * #%L
 * JAXX :: Application Swing
 * $Id: DelegateTabContainerHandler.java 2826 2014-05-13 16:57:33Z kmorin $
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Code Lutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;

import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JTabbedPane;
import java.awt.Component;

/**
 * Created on 11/25/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.8
 */
public class DelegateTabContainerHandler implements TabContainerHandler {

    final JTabbedPane tabbedPane;

    public DelegateTabContainerHandler(JTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
    }

    @Override
    public JTabbedPane getTabPanel() {
        return tabbedPane;
    }

    @Override
    public void init() {

        getTabPanel().setModel(new DefaultSingleSelectionModel() {

            private static final long serialVersionUID = 1L;

            @Override
            public void setSelectedIndex(int index) {
                int currentIndex = getTabPanel().getSelectedIndex();
                boolean mustChangeTab = onTabChanged(currentIndex, index);

                if (mustChangeTab) {
                    super.setSelectedIndex(index);
                }
            }

        });
    }

    @Override
    public boolean onTabChanged(int currentIndex, int newIndex) {
        boolean result = true;
        if (currentIndex != newIndex) {
            TabHandler handler = getTabHandler(currentIndex);
            if (handler != null) {
                result = handler.onHideTab(currentIndex, newIndex);
            }

            handler = getTabHandler(newIndex);
            if (handler != null) {
                handler.onShowTab(currentIndex, newIndex);
            }
        }
        return result;
    }

    @Override
    public TabHandler getTabHandler(int index) {
        TabHandler tabHandler = null;
        JTabbedPane tabPanel = getTabPanel();
        if (index >= 0 && index < tabPanel.getTabCount()) {
            Component tab = tabPanel.getComponentAt(index);
            if (ApplicationUI.class.isInstance(tab)) {
                ApplicationUI tuttiTab = (ApplicationUI) tabPanel.getComponentAt(index);
                AbstractApplicationUIHandler handler = tuttiTab.getHandler();
                if (TabHandler.class.isInstance(handler)) {
                    tabHandler = (TabHandler) handler;
                }
            }
        }
        return tabHandler;
    }

    @Override
    public void setCustomTab(int index, TabContentModel model) {
        JTabbedPane tabPanel = getTabPanel();
        tabPanel.setTabComponentAt(index, new CustomTab(model, this));
    }

    @Override
    public boolean removeTab(int i) {
        TabHandler tabHandler = getTabHandler(i);
        boolean remove = tabHandler.onRemoveTab();
        if (remove) {
            getTabPanel().removeTabAt(i);
        }
        return remove;
    }
}
