package org.nuiton.jaxx.application.swing.util;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.JTables;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;

import javax.swing.JTable;
import java.awt.Color;
import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import static org.nuiton.i18n.I18n.t;

/**
 * Useful ui methods.
 *
 * Created on 11/23/13.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8
 */
public class ApplicationUIUtil {

    /** Logger. */
    private static final Log log = LogFactory.getLog(ApplicationUIUtil.class);

    protected ApplicationUIUtil() {
        // avoid instanciate util class
    }

    public static void setApplicationContext(JAXXObject ui, ApplicationUIContext context) {
        ui.setContextValue(context, "applicationContext");
    }

    public static ApplicationUIContext getApplicationContext(JAXXObject ui) {
        return ui.getContextValue(ApplicationUIContext.class, "applicationContext");
    }

    public static Highlighter newBackgroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new ApplicationColorHighlighter(predicate, color, false);
    }

    public static Highlighter newForegroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new ApplicationColorHighlighter(predicate, color, true);
    }

    public static void openLink(URL url) {
        try {
            openLink(url.toURI());
        } catch (URISyntaxException e) {
            throw new ApplicationTechnicalException(t("jaxx.application.error.cannot.open.link", url), e);
        }
    }

    public static Desktop getDesktopForBrowse() {

        if (!Desktop.isDesktopSupported()) {
            throw new ApplicationTechnicalException(
                    t("jaxx.application.error.desktop.not.supported"));
        }

        Desktop desktop = Desktop.getDesktop();

        if (!desktop.isSupported(Desktop.Action.BROWSE)) {

            throw new ApplicationTechnicalException(
                    t("jaxx.application.error.desktop.browse.not.supported"));
        }

        return desktop;
    }

    public static Desktop getDesktopForOpen() {

        if (!Desktop.isDesktopSupported()) {
            throw new ApplicationTechnicalException(
                    t("jaxx.application.error.desktop.not.supported"));
        }

        Desktop desktop = Desktop.getDesktop();

        if (!desktop.isSupported(Desktop.Action.OPEN)) {

            throw new ApplicationTechnicalException(
                    t("jaxx.application.error.desktop.open.not.supported"));
        }

        return desktop;
    }

    public static void openLink(URI uri) {

        Desktop desktop = getDesktopForBrowse();

        try {

            desktop.browse(uri);
        } catch (Exception e) {

            throw new ApplicationTechnicalException(
                    t("jaxx.application.error.cannot.open.link", uri), e);
        }
    }

    public static Desktop getDesktopForMail() {

        if (!Desktop.isDesktopSupported()) {
            throw new ApplicationTechnicalException(
                    t("jaxx.application.error.desktop.not.supported"));
        }

        Desktop desktop = Desktop.getDesktop();

        if (!desktop.isSupported(Desktop.Action.MAIL)) {

            throw new ApplicationTechnicalException(
                    t("jaxx.application.error.desktop.mail.not.supported"));
        }

        return desktop;
    }

    public static void mail(String subject, String body) {

        Desktop desktop = getDesktopForMail();

        try {
            URI mailtoURI = new URI("mailto", null, null, "subject=" + subject + "&body=" + body, null);
            desktop.mail(mailtoURI);

        } catch (Exception e) {

            throw new ApplicationTechnicalException(
                    t("jaxx.application.error.cannot.mail"), e);
        }
    }

    /**
     * @deprecated since 2.18, use instead {@link JTables#selectFirstCellOnFirstRowAndStopEditing(JTable)}
     */
    @Deprecated
    public static void selectFirstCellOnFirstRowAndStopEditing(JXTable table) {

        JTables.selectFirstCellOnFirstRowAndStopEditing(table);

    }

    /**
     * @deprecated since 2.18, use instead {@link JTables#selectFirstCellOnLastRow(JTable)}
     */
    @Deprecated
    public static void selectFirstCellOnLastRow(JXTable table) {

        JTables.selectFirstCellOnLastRow(table);

    }

    /**
     * @deprecated since 2.18, use instead {@link JTables#selectFirstCellOnRow(JTable, int, boolean)}
     */
    @Deprecated
    public static void selectFirstCellOnRow(JXTable table, int row, boolean stopEdit) {

        JTables.selectFirstCellOnRow(table, row, stopEdit);

    }

    /**
     * @deprecated since 2.18, use instead {@link JTables#doSelectCell(JTable, int, int)}
     */
    @Deprecated
    public static void doSelectCell(JTable table, int rowIndex, int columnIndex) {

        JTables.doSelectCell(table, rowIndex, columnIndex);

    }

}
