package org.nuiton.jaxx.application.bean;

/*
 * #%L
 * JAXX :: Application API
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;

/**
 * Created on 8/14/14.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.10
 */
public class JavaBeanObjectUtil {

    /** Logger. */
    private static final Log log = LogFactory.getLog(JavaBeanObjectUtil.class);

    public static void removeAllPropertyChangeListeners(Iterable<? extends JavaBeanObject> beans) {
        for (JavaBeanObject bean : beans) {
            removeAllPropertyChangeListeners(bean);
        }
    }

    public static void removeAllPropertyChangeListeners(JavaBeanObject bean) {

        removePropertyChangeListeners(bean, Predicates.<PropertyChangeListener>alwaysTrue());

    }

    public static void removeAllRemovablePropertyChangeListeners(JavaBeanObject bean) {

        removePropertyChangeListeners(bean, new Predicate<PropertyChangeListener>() {
            @Override
            public boolean apply(PropertyChangeListener input) {
                return input instanceof RemoveablePropertyChangeListener;
            }
        });

    }

    public static void removePropertyChangeListeners(JavaBeanObject bean, Predicate<PropertyChangeListener> predicate) {

        PropertyChangeListener[] propertyChangeListeners = bean.getPropertyChangeListeners();
        for (PropertyChangeListener listener : propertyChangeListeners) {

            if (listener instanceof PropertyChangeListenerProxy) {

                PropertyChangeListenerProxy listenerProxy = (PropertyChangeListenerProxy) listener;
                listener = listenerProxy.getListener();

            }

            if (predicate.apply(listener)) {

                if (log.isDebugEnabled()) {
                    log.debug("Remove listener: " + listener);
                }
                bean.removePropertyChangeListener(listener);

            }

        }

    }
}
