/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.maven.project.MavenProject;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.Plugin;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginWithEncoding;

public abstract class AbstractI18nMojo
extends AbstractPlugin
implements PluginWithEncoding {
    private static int NB_GETTER_FILES;
    protected MavenProject project;
    protected String artifactId;
    protected String bundles;
    protected File src;
    protected File out;
    protected String encoding;
    protected boolean genSrc;
    protected boolean verbose;
    protected boolean silent;
    protected boolean strictMode;
    protected Locale[] locales;

    protected boolean checkPackaging() {
        return !this.acceptPackaging(new Plugin.Packaging[]{Plugin.Packaging.pom});
    }

    public void init() throws Exception {
        if (this.verbose) {
            this.silent = false;
            this.getLog().info((CharSequence)"config - verbose mode is on");
        }
        this.locales = I18nUtil.parseLocales((String)this.bundles);
        if (this.locales == null || this.locales.length == 0) {
            throw new IllegalStateException("Il faut au moins une locale declaree (utiliser la propriete 'bundles')");
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    protected boolean needGeneration() {
        boolean needGeneration = NB_GETTER_FILES > 0;
        return needGeneration;
    }

    protected void addGetter() {
        ++NB_GETTER_FILES;
    }

    public File getI18nFile(File root, String artifactId, Locale locale, boolean create) throws IOException {
        String path = root.getAbsolutePath() + File.separatorChar + artifactId;
        if (locale != null) {
            path = path + "_" + locale.toString();
        }
        path = path + ".properties";
        File file = new File(path);
        if (create && !file.exists()) {
            this.createNewFile(file);
        }
        return file;
    }

    public File getGetterFile(File root, String getter, boolean create) throws IOException {
        File file = new File(root.getAbsolutePath() + File.separatorChar + getter);
        if (create && !file.exists()) {
            this.createNewFile(file);
        }
        return file;
    }

    protected void checkBundle(Locale locale, Properties propertiesOut, boolean showEmpty, Map<Locale, SortedSet<String>> unsafeHolder) {
        SortedSet emptyEntries = PluginHelper.getEmptyKeys((Map)propertiesOut);
        if (!emptyEntries.isEmpty()) {
            if (unsafeHolder != null) {
                SortedSet<String> empties = unsafeHolder.get(locale);
                if (empties == null) {
                    empties = new TreeSet<String>();
                    unsafeHolder.put(locale, empties);
                }
                empties.addAll(emptyEntries);
            }
            StringBuilder buffer = new StringBuilder();
            int size = emptyEntries.size();
            buffer.append("bundle ");
            buffer.append(locale);
            buffer.append(" contains ");
            buffer.append(size);
            buffer.append("/");
            buffer.append(propertiesOut.size());
            buffer.append(" empty entries!");
            if (showEmpty) {
                int index = 0;
                for (String key : emptyEntries) {
                    buffer.append("\n  - ");
                    buffer.append(index++);
                    buffer.append("/");
                    buffer.append(size);
                    buffer.append(" : ");
                    buffer.append(key);
                }
            } else {
                buffer.append(" (use -Di18n.showEmpty to see these entries)");
            }
            this.getLog().warn((CharSequence)buffer.toString());
        } else if (!this.silent && this.verbose) {
            this.getLog().info((CharSequence)("bundle " + locale + " is valid (no empty" + " entries)."));
        }
    }

    public File getBackupFile(File file) {
        return new File(file.getAbsolutePath() + "~");
    }

    protected void backupFile(File f) throws IOException {
        File dst = this.getBackupFile(f);
        this.copyFile(f, dst);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

