package org.nuiton.i18n.plugin.parser.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-i18n-plugin.<br/> Call <pre>  mvn i18n:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Apr 29 07:43:59 CEST 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.nuiton.i18n:maven-i18n-plugin:1.2.2", 0 );
        append( sb, "", 0 );

        append( sb, "I18n :: Maven Plugin", 0 );
        append( sb, "Plugin pour maven 2 de g\u00e9n\u00e9ration des bundles pour l\'internationalisation (i18n) des applications java bas\u00e9 sur nuiton-i18n-api.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 10 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "bundle".equals( goal ) )
        {
            append( sb, "i18n:bundle", 0 );
            append( sb, "Cr\u00e9er un bundle pour une application finale.\nCela g\u00e9n\u00e8re un merge de tous les fichiers i18n utilis\u00e9s en un seul.\n\nOn utilise la d\u00e9pendance sur les artifacts pour connaitre l\'ordre le chargement des bundles.\n\nSi dans un bundle childs, la valeur de la clef est vide, on conserve alors celui du parent,\n\nAinsi on obtient un bundle dont toutes les clefs sont traduites.\n\nLe but aussi d\'utiliser un unique bundle est de gagner du temps au runtime car la recherche des bundles devient trop couteuse en temps lorsque l\'on a de nombreuses d\u00e9pendances (au dessus de 100 deps cela peut prendre plusieurs secondes, ce qui \'est pas acceptable).\n\nOn a ajoute un second mode d\'initialisation dans la clesse I18n pour n\'utiliser qu\'un seul bundle et courcircuiter le chargement couteux...\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "bundleOutputDir (Default: ${basedir}/target/generated-sources/resources/META-INF)", 2 );
                append( sb, "Repertoire ou generer les bundles.", 3 );
                append( sb, "", 0 );

                append( sb, "bundleOutputName (Default: ${project.artifactId}-i18n)", 2 );
                append( sb, "Nom du bundle a generer.", 3 );
                append( sb, "", 0 );

                append( sb, "bundles (Default: fr_FR,en_GB)", 2 );
                append( sb, "Langues des bundles generes.\n", 3 );
                append( sb, "", 0 );

                append( sb, "checkBundle (Default: true)", 2 );
                append( sb, "Un drapeau pour v\u00e9rifier que les bundles ne contiennent pas d\'entr\u00e9es vides.", 3 );
                append( sb, "", 0 );

                append( sb, "collectOutputDir (Default: ${basedir}/target/i18n)", 2 );
                append( sb, "Repertoire ou generer les bundles.", 3 );
                append( sb, "", 0 );

                append( sb, "collectOutputName (Default: collect-${project.artifactId}-i18n)", 2 );
                append( sb, "Nom de base des fichiers qui contient les localisations des bundles.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "encoding a utiliser pour charger et sauver les bundles", 3 );
                append( sb, "", 0 );

                append( sb, "genSrc (Default: true)", 2 );
                append( sb, "Met les fichiers generes dans le repertoire des sources i18n.\nNote: Par d\u00e9faut active, pour pouvoir paquager avec les bundles mis a jour.\n", 3 );
                append( sb, "", 0 );

                append( sb, "out (Default: ${basedir}/target/generated-sources/i18n)", 2 );
                append( sb, "Repertoire des fichiers generes i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "Dependance du projet.", 3 );
                append( sb, "", 0 );

                append( sb, "showEmpty (Default: false)", 2 );
                append( sb, "Un drapeau pour afficher les entr\u00e9es vides. (n\u00e9cessite checkBundle activ\u00e9).", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "silent flag", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources/i18n)", 2 );
                append( sb, "Repertoire sources des fichiers i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "strictMode (Default: false)", 2 );
                append( sb, "ne conserve que les clef scannees (et donc traite tous les fichiers)\n\nNote : par default, on ne l\'active car rescanne tous les fichiers. s\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "verbose flag\nNote: si non renseigne, on utilise la propi\u00e9t\u00e9 maven.verbose.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "collect-i18n-artifacts".equals( goal ) )
        {
            append( sb, "i18n:collect-i18n-artifacts", 0 );
            append( sb, "Detects any i18n artifacts and store the result as a file.\nCreated: 24 d\u00e9c. 2009\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "bundles (Default: fr_FR,en_GB)", 2 );
                append( sb, "Langues des bundles generes.\n", 3 );
                append( sb, "", 0 );

                append( sb, "collectOutputDir (Default: ${basedir}/target/i18n)", 2 );
                append( sb, "Repertoire ou generer les bundles.", 3 );
                append( sb, "", 0 );

                append( sb, "collectOutputName (Default: collect-${project.artifactId}-i18n)", 2 );
                append( sb, "Nom de base des fichiers qui contient les localisations des bundles.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "encoding a utiliser pour charger et sauver les bundles", 3 );
                append( sb, "", 0 );

                append( sb, "genSrc (Default: true)", 2 );
                append( sb, "Met les fichiers generes dans le repertoire des sources i18n.\nNote: Par d\u00e9faut active, pour pouvoir paquager avec les bundles mis a jour.\n", 3 );
                append( sb, "", 0 );

                append( sb, "out (Default: ${basedir}/target/generated-sources/i18n)", 2 );
                append( sb, "Repertoire des fichiers generes i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "Dependance du projet.", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "silent flag", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources/i18n)", 2 );
                append( sb, "Repertoire sources des fichiers i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "strictMode (Default: false)", 2 );
                append( sb, "ne conserve que les clef scannees (et donc traite tous les fichiers)\n\nNote : par default, on ne l\'active car rescanne tous les fichiers. s\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "verbose flag\nNote: si non renseigne, on utilise la propi\u00e9t\u00e9 maven.verbose.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "gen".equals( goal ) )
        {
            append( sb, "i18n:gen", 0 );
            append( sb, "Merge des fichiers de propri\u00e9t\u00e9s avec les anciens.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "bundles (Default: fr_FR,en_GB)", 2 );
                append( sb, "Langues des bundles generes.\n", 3 );
                append( sb, "", 0 );

                append( sb, "checkBundle (Default: true)", 2 );
                append( sb, "Un drapeau pour v\u00e9rifier que les bundles ne contiennent pas d\'entr\u00e9es vides.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "encoding a utiliser pour charger et sauver les bundles", 3 );
                append( sb, "", 0 );

                append( sb, "genSrc (Default: true)", 2 );
                append( sb, "Met les fichiers generes dans le repertoire des sources i18n.\nNote: Par d\u00e9faut active, pour pouvoir paquager avec les bundles mis a jour.\n", 3 );
                append( sb, "", 0 );

                append( sb, "keepBackup (Default: false)", 2 );
                append( sb, "conserve les anciens fichiers de traduction avec un suffix ~\nNote: par defaut, on ne l\'active pas.\n", 3 );
                append( sb, "", 0 );

                append( sb, "keepGetters (Default: false)", 2 );
                append( sb, "Conserve les fichiers de getters.", 3 );
                append( sb, "", 0 );

                append( sb, "out (Default: ${basedir}/target/generated-sources/i18n)", 2 );
                append( sb, "Repertoire des fichiers generes i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "Dependance du projet.", 3 );
                append( sb, "", 0 );

                append( sb, "showEmpty (Default: false)", 2 );
                append( sb, "Un drapeau pour afficher les entr\u00e9es vides. (n\u00e9cessite checkBundle activ\u00e9).", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "silent flag", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources/i18n)", 2 );
                append( sb, "Repertoire sources des fichiers i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "strictMode (Default: false)", 2 );
                append( sb, "ne conserve que les clef scannees (et donc traite tous les fichiers)\n\nNote : par default, on ne l\'active car rescanne tous les fichiers. s\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "verbose flag\nNote: si non renseigne, on utilise la propi\u00e9t\u00e9 maven.verbose.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "get".equals( goal ) )
        {
            append( sb, "i18n:get", 0 );
            append( sb, "Recupere les diff\u00e9rents fichiers des parsers en un fichier de proprietes.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "bundles (Default: fr_FR,en_GB)", 2 );
                append( sb, "Langues des bundles generes.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "encoding a utiliser pour charger et sauver les bundles", 3 );
                append( sb, "", 0 );

                append( sb, "genSrc (Default: true)", 2 );
                append( sb, "Met les fichiers generes dans le repertoire des sources i18n.\nNote: Par d\u00e9faut active, pour pouvoir paquager avec les bundles mis a jour.\n", 3 );
                append( sb, "", 0 );

                append( sb, "keepGetters (Default: false)", 2 );
                append( sb, "Conserve les fichiers de getters.", 3 );
                append( sb, "", 0 );

                append( sb, "out (Default: ${basedir}/target/generated-sources/i18n)", 2 );
                append( sb, "Repertoire des fichiers generes i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "Dependance du projet.", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "silent flag", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources/i18n)", 2 );
                append( sb, "Repertoire sources des fichiers i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "strictMode (Default: false)", 2 );
                append( sb, "ne conserve que les clef scannees (et donc traite tous les fichiers)\n\nNote : par default, on ne l\'active car rescanne tous les fichiers. s\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "verbose flag\nNote: si non renseigne, on utilise la propi\u00e9t\u00e9 maven.verbose.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "i18n:help", 0 );
            append( sb, "Display help information on maven-i18n-plugin.\nCall\n\u00a0\u00a0mvn\u00a0i18n:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "parserJava".equals( goal ) )
        {
            append( sb, "i18n:parserJava", 0 );
            append( sb, "R\u00e9cup\u00e9ration des chaine a traduire depuis les fichiers java.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "backupGetter (Default: false)", 2 );
                append( sb, "flag to save previous getter in a backup before doing parsing.\nNote: by default, do not perform backup (but it was here originaly so let it possible...)\n", 3 );
                append( sb, "", 0 );

                append( sb, "bundles (Default: fr_FR,en_GB)", 2 );
                append( sb, "Langues des bundles generes.\n", 3 );
                append( sb, "", 0 );

                append( sb, "cp (Default: ${basedir}/target/classes)", 2 );
                append( sb, "Repertoire sources des fichiers i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultBasedir (Default: ${basedir}/src/main/java)", 2 );
                append( sb, "default src for an entry.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultIncludes (Default: **/*.java)", 2 );
                append( sb, "Source entries (src+includes+excludes) .", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "encoding a utiliser pour charger et sauver les bundles", 3 );
                append( sb, "", 0 );

                append( sb, "entries", 2 );
                append( sb, "Source entries (src+includes+excludes) .", 3 );
                append( sb, "", 0 );

                append( sb, "force (Default: false)", 2 );
                append( sb, "To force reparse of all sources.", 3 );
                append( sb, "", 0 );

                append( sb, "genSrc (Default: true)", 2 );
                append( sb, "Met les fichiers generes dans le repertoire des sources i18n.\nNote: Par d\u00e9faut active, pour pouvoir paquager avec les bundles mis a jour.\n", 3 );
                append( sb, "", 0 );

                append( sb, "keysModifier (Default: false)", 2 );
                append( sb, "Deprecated. since 1.2, will no more used", 3 );
                append( sb, "", 0 );
                append( sb, "Active la modification de cle.\nNote: par defaut, on ne l\'active pas (build sur serveur non ui).\n\nNote: Ce param\u00e8tre n\'est plus actif, la fonctionnalit\u00e9 n\'est plus disponible et sera remplac\u00e9 par un autre goal.\n", 3 );
                append( sb, "", 0 );

                append( sb, "out (Default: ${basedir}/target/generated-sources/i18n)", 2 );
                append( sb, "Repertoire des fichiers generes i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "Dependance du projet.", 3 );
                append( sb, "", 0 );

                append( sb, "safeMode (Default: false)", 2 );
                append( sb, "Deprecated. since 1.2, no more used", 3 );
                append( sb, "", 0 );
                append( sb, "flag to save at eachfile treated the getter file", 3 );
                append( sb, "", 0 );

                append( sb, "showTouchedFiles (Default: ${maven.verbose})", 2 );
                append( sb, "flag to display touched files while parsing.\nNote: the value will be always true if verbose is set at true.\n", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "silent flag", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources/i18n)", 2 );
                append( sb, "Repertoire sources des fichiers i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "strictMode (Default: false)", 2 );
                append( sb, "ne conserve que les clef scannees (et donc traite tous les fichiers)\n\nNote : par default, on ne l\'active car rescanne tous les fichiers. s\n", 3 );
                append( sb, "", 0 );

                append( sb, "treateDefaultEntry (Default: true)", 2 );
                append( sb, "treate default entry", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "verbose flag\nNote: si non renseigne, on utilise la propi\u00e9t\u00e9 maven.verbose.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "parserJavaActionConfig".equals( goal ) )
        {
            append( sb, "i18n:parserJavaActionConfig", 0 );
            append( sb, "Un parseur java pour scanner les annotations ActionConfig", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "backupGetter (Default: false)", 2 );
                append( sb, "flag to save previous getter in a backup before doing parsing.\nNote: by default, do not perform backup (but it was here originaly so let it possible...)\n", 3 );
                append( sb, "", 0 );

                append( sb, "bundles (Default: fr_FR,en_GB)", 2 );
                append( sb, "Langues des bundles generes.\n", 3 );
                append( sb, "", 0 );

                append( sb, "cp (Default: ${basedir}/target/classes)", 2 );
                append( sb, "Repertoire sources des fichiers i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultBasedir (Default: ${basedir}/src/main/java)", 2 );
                append( sb, "default src for an entry.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultIncludes (Default: **/*.java)", 2 );
                append( sb, "Source entries (src+includes+excludes) .", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "encoding a utiliser pour charger et sauver les bundles", 3 );
                append( sb, "", 0 );

                append( sb, "entries", 2 );
                append( sb, "Source entries (src+includes+excludes) .", 3 );
                append( sb, "", 0 );

                append( sb, "force (Default: false)", 2 );
                append( sb, "To force reparse of all sources.", 3 );
                append( sb, "", 0 );

                append( sb, "genSrc (Default: true)", 2 );
                append( sb, "Met les fichiers generes dans le repertoire des sources i18n.\nNote: Par d\u00e9faut active, pour pouvoir paquager avec les bundles mis a jour.\n", 3 );
                append( sb, "", 0 );

                append( sb, "keysModifier (Default: false)", 2 );
                append( sb, "Deprecated. since 1.2, will no more used", 3 );
                append( sb, "", 0 );
                append( sb, "Active la modification de cle.\nNote: par defaut, on ne l\'active pas (build sur serveur non ui).\n\nNote: Ce param\u00e8tre n\'est plus actif, la fonctionnalit\u00e9 n\'est plus disponible et sera remplac\u00e9 par un autre goal.\n", 3 );
                append( sb, "", 0 );

                append( sb, "out (Default: ${basedir}/target/generated-sources/i18n)", 2 );
                append( sb, "Repertoire des fichiers generes i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "Dependance du projet.", 3 );
                append( sb, "", 0 );

                append( sb, "safeMode (Default: false)", 2 );
                append( sb, "Deprecated. since 1.2, no more used", 3 );
                append( sb, "", 0 );
                append( sb, "flag to save at eachfile treated the getter file", 3 );
                append( sb, "", 0 );

                append( sb, "showTouchedFiles (Default: ${maven.verbose})", 2 );
                append( sb, "flag to display touched files while parsing.\nNote: the value will be always true if verbose is set at true.\n", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "silent flag", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources/i18n)", 2 );
                append( sb, "Repertoire sources des fichiers i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "strictMode (Default: false)", 2 );
                append( sb, "ne conserve que les clef scannees (et donc traite tous les fichiers)\n\nNote : par default, on ne l\'active car rescanne tous les fichiers. s\n", 3 );
                append( sb, "", 0 );

                append( sb, "treateDefaultEntry (Default: true)", 2 );
                append( sb, "treate default entry", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "verbose flag\nNote: si non renseigne, on utilise la propi\u00e9t\u00e9 maven.verbose.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "parserJavaTabConfig".equals( goal ) )
        {
            append( sb, "i18n:parserJavaTabConfig", 0 );
            append( sb, "Un parseur java pour scanner les annotations TabContentConfig.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "backupGetter (Default: false)", 2 );
                append( sb, "flag to save previous getter in a backup before doing parsing.\nNote: by default, do not perform backup (but it was here originaly so let it possible...)\n", 3 );
                append( sb, "", 0 );

                append( sb, "bundles (Default: fr_FR,en_GB)", 2 );
                append( sb, "Langues des bundles generes.\n", 3 );
                append( sb, "", 0 );

                append( sb, "cp (Default: ${basedir}/target/classes)", 2 );
                append( sb, "Repertoire sources des fichiers i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultBasedir (Default: ${basedir}/src/main/java)", 2 );
                append( sb, "default src for an entry.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultIncludes (Default: **/*.java)", 2 );
                append( sb, "Source entries (src+includes+excludes) .", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "encoding a utiliser pour charger et sauver les bundles", 3 );
                append( sb, "", 0 );

                append( sb, "entries", 2 );
                append( sb, "Source entries (src+includes+excludes) .", 3 );
                append( sb, "", 0 );

                append( sb, "force (Default: false)", 2 );
                append( sb, "To force reparse of all sources.", 3 );
                append( sb, "", 0 );

                append( sb, "genSrc (Default: true)", 2 );
                append( sb, "Met les fichiers generes dans le repertoire des sources i18n.\nNote: Par d\u00e9faut active, pour pouvoir paquager avec les bundles mis a jour.\n", 3 );
                append( sb, "", 0 );

                append( sb, "keysModifier (Default: false)", 2 );
                append( sb, "Deprecated. since 1.2, will no more used", 3 );
                append( sb, "", 0 );
                append( sb, "Active la modification de cle.\nNote: par defaut, on ne l\'active pas (build sur serveur non ui).\n\nNote: Ce param\u00e8tre n\'est plus actif, la fonctionnalit\u00e9 n\'est plus disponible et sera remplac\u00e9 par un autre goal.\n", 3 );
                append( sb, "", 0 );

                append( sb, "out (Default: ${basedir}/target/generated-sources/i18n)", 2 );
                append( sb, "Repertoire des fichiers generes i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "Dependance du projet.", 3 );
                append( sb, "", 0 );

                append( sb, "safeMode (Default: false)", 2 );
                append( sb, "Deprecated. since 1.2, no more used", 3 );
                append( sb, "", 0 );
                append( sb, "flag to save at eachfile treated the getter file", 3 );
                append( sb, "", 0 );

                append( sb, "showTouchedFiles (Default: ${maven.verbose})", 2 );
                append( sb, "flag to display touched files while parsing.\nNote: the value will be always true if verbose is set at true.\n", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "silent flag", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources/i18n)", 2 );
                append( sb, "Repertoire sources des fichiers i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "strictMode (Default: false)", 2 );
                append( sb, "ne conserve que les clef scannees (et donc traite tous les fichiers)\n\nNote : par default, on ne l\'active car rescanne tous les fichiers. s\n", 3 );
                append( sb, "", 0 );

                append( sb, "treateDefaultEntry (Default: true)", 2 );
                append( sb, "treate default entry", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "verbose flag\nNote: si non renseigne, on utilise la propi\u00e9t\u00e9 maven.verbose.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "parserValidation".equals( goal ) )
        {
            append( sb, "i18n:parserValidation", 0 );
            append( sb, "R\u00e9cup\u00e9ration des chaine \u00e0 traduire depuis les fichiers xml de validation.\nLe goal doit etre execute avant que les resources soient copiees dans target\nclasses pour rendre operatne le file updater (sinon lesfichiers sont toujours a jour...)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "backupGetter (Default: false)", 2 );
                append( sb, "flag to save previous getter in a backup before doing parsing.\nNote: by default, do not perform backup (but it was here originaly so let it possible...)\n", 3 );
                append( sb, "", 0 );

                append( sb, "bundles (Default: fr_FR,en_GB)", 2 );
                append( sb, "Langues des bundles generes.\n", 3 );
                append( sb, "", 0 );

                append( sb, "cp (Default: ${basedir}/target/classes)", 2 );
                append( sb, "Where jaxx files should have been generated.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultBasedir (Default: ${basedir}/src/main/resources)", 2 );
                append( sb, "default src for an entry.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultIncludes (Default: **/**-validation.xml)", 2 );
                append( sb, "Source entries (src+includes+excludes) .", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "encoding a utiliser pour charger et sauver les bundles", 3 );
                append( sb, "", 0 );

                append( sb, "entries", 2 );
                append( sb, "Source entries (src+includes+excludes) .", 3 );
                append( sb, "", 0 );

                append( sb, "force (Default: false)", 2 );
                append( sb, "To force reparse of all sources.", 3 );
                append( sb, "", 0 );

                append( sb, "genSrc (Default: true)", 2 );
                append( sb, "Met les fichiers generes dans le repertoire des sources i18n.\nNote: Par d\u00e9faut active, pour pouvoir paquager avec les bundles mis a jour.\n", 3 );
                append( sb, "", 0 );

                append( sb, "keysModifier (Default: false)", 2 );
                append( sb, "Deprecated. since 1.2, will no more used", 3 );
                append( sb, "", 0 );
                append( sb, "Active la modification de cle.\nNote: par defaut, on ne l\'active pas (build sur serveur non ui).\n\nNote: Ce param\u00e8tre n\'est plus actif, la fonctionnalit\u00e9 n\'est plus disponible et sera remplac\u00e9 par un autre goal.\n", 3 );
                append( sb, "", 0 );

                append( sb, "out (Default: ${basedir}/target/generated-sources/i18n)", 2 );
                append( sb, "Repertoire des fichiers generes i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "Dependance du projet.", 3 );
                append( sb, "", 0 );

                append( sb, "rulesValidation (Default: validation.rules)", 2 );
                append( sb, "Regles xml.", 3 );
                append( sb, "", 0 );

                append( sb, "safeMode (Default: false)", 2 );
                append( sb, "Deprecated. since 1.2, no more used", 3 );
                append( sb, "", 0 );
                append( sb, "flag to save at eachfile treated the getter file", 3 );
                append( sb, "", 0 );

                append( sb, "showTouchedFiles (Default: ${maven.verbose})", 2 );
                append( sb, "flag to display touched files while parsing.\nNote: the value will be always true if verbose is set at true.\n", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "silent flag", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources/i18n)", 2 );
                append( sb, "Repertoire sources des fichiers i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "strictMode (Default: false)", 2 );
                append( sb, "ne conserve que les clef scannees (et donc traite tous les fichiers)\n\nNote : par default, on ne l\'active car rescanne tous les fichiers. s\n", 3 );
                append( sb, "", 0 );

                append( sb, "treateDefaultEntry (Default: true)", 2 );
                append( sb, "treate default entry", 3 );
                append( sb, "", 0 );

                append( sb, "useLocalResolver (Default: true)", 2 );
                append( sb, "Always use the local xowrks dtd to increase performance.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "verbose flag\nNote: si non renseigne, on utilise la propi\u00e9t\u00e9 maven.verbose.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "tapestry-bundle".equals( goal ) )
        {
            append( sb, "i18n:tapestry-bundle", 0 );
            append( sb, "Cr\u00e9er un bundle pour une application finale.\nCela g\u00e9n\u00e8re un merge de tous les fichiers i18n utilis\u00e9s en un seul.\n\nOn utilise la d\u00e9pendance sur les artifacts pour connaitre l\'ordre le chargement des bundles.\n\nSi dans un bundle childs, la valeur de la clef est vide, on conserve alors celui du parent,\n\nAinsi on obtient un bundle dont toutes les clefs sont traduites.\n\nLe but aussi d\'utiliser un unique bundle est de gagner du temps au runtime car la recherche des bundles devient trop couteuse en temps lorsque l\'on a de nombreuses d\u00e9pendances (au dessus de 100 deps cela peut prendre plusieurs secondes, ce qui \'est pas acceptable).\n\nOn a ajoute un second mode d\'initialisation dans la clesse I18n pour n\'utiliser qu\'un seul bundle et courcircuiter le chargement couteux...\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "bundleOutputDir (Default: ${basedir}/src/main/webapp/WEB-INF)", 2 );
                append( sb, "Repertoire ou generer les bundles.", 3 );
                append( sb, "", 0 );

                append( sb, "bundleOutputName (Default: app)", 2 );
                append( sb, "Nom du bundle a generer.", 3 );
                append( sb, "", 0 );

                append( sb, "bundles (Default: fr_FR,en_GB)", 2 );
                append( sb, "Langues des bundles generes.\n", 3 );
                append( sb, "", 0 );

                append( sb, "checkBundle (Default: true)", 2 );
                append( sb, "Un drapeau pour v\u00e9rifier que les bundles ne contiennent pas d\'entr\u00e9es vides.", 3 );
                append( sb, "", 0 );

                append( sb, "collectOutputDir (Default: ${basedir}/target/i18n)", 2 );
                append( sb, "Repertoire ou generer les bundles.", 3 );
                append( sb, "", 0 );

                append( sb, "collectOutputName (Default: collect-${project.artifactId}-i18n)", 2 );
                append( sb, "Nom de base des fichiers qui contient les localisations des bundles.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "encoding a utiliser pour charger et sauver les bundles", 3 );
                append( sb, "", 0 );

                append( sb, "genSrc (Default: true)", 2 );
                append( sb, "Met les fichiers generes dans le repertoire des sources i18n.\nNote: Par d\u00e9faut active, pour pouvoir paquager avec les bundles mis a jour.\n", 3 );
                append( sb, "", 0 );

                append( sb, "out (Default: ${basedir}/target/generated-sources/i18n)", 2 );
                append( sb, "Repertoire des fichiers generes i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "Dependance du projet.", 3 );
                append( sb, "", 0 );

                append( sb, "showEmpty (Default: false)", 2 );
                append( sb, "Un drapeau pour afficher les entr\u00e9es vides. (n\u00e9cessite checkBundle activ\u00e9).", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "silent flag", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources/i18n)", 2 );
                append( sb, "Repertoire sources des fichiers i18n.", 3 );
                append( sb, "", 0 );

                append( sb, "strictMode (Default: false)", 2 );
                append( sb, "ne conserve que les clef scannees (et donc traite tous les fichiers)\n\nNote : par default, on ne l\'active car rescanne tous les fichiers. s\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "verbose flag\nNote: si non renseigne, on utilise la propi\u00e9t\u00e9 maven.verbose.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
