/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.nuiton.i18n.plugin.AbstractI18nPlugin;
import org.nuiton.util.PluginHelper;

public class Getter
extends AbstractI18nPlugin {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        if (!this.needGeneration()) {
            if (this.verbose) {
                this.getLog().info((CharSequence)"Nothing to generate - all files are up to date.");
            }
            return;
        }
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - basedir : " + this.out.getAbsolutePath()));
            this.getLog().info((CharSequence)("config - locales     : " + Arrays.toString(this.locales)));
        }
        try {
            File bundleGetters = new File(this.out.getAbsolutePath() + File.separatorChar + this.artifactId + ".properties");
            bundleGetters.createNewFile();
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(this.out);
            ds.setIncludes(new String[]{"*.getter"});
            ds.scan();
            String[] files = ds.getIncludedFiles();
            for (String file : files) {
                long t0 = System.nanoTime();
                File bundleGetter = this.getGetterFile(this.out, file, false);
                this.concactProperties(bundleGetter, bundleGetters);
                if (this.genSrc) {
                    bundleGetter.delete();
                }
                if (this.silent) continue;
                this.getLog().info((CharSequence)("import getter " + bundleGetter.getName() + " in " + PluginHelper.convertTime((long)(System.nanoTime() - t0))));
            }
            for (Locale locale : this.locales) {
                if (!this.silent && this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("generate bundle for locale " + locale));
                }
                File bundleOut = this.getI18nFile(this.out, this.artifactId, locale, false);
                this.copyFile(bundleGetters, bundleOut);
                if (this.silent || !this.verbose) continue;
                this.getLog().info((CharSequence)("generate bundle " + locale));
            }
            bundleGetters.delete();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"File Error I/O ", (Throwable)e);
            throw new MojoFailureException("File Error I/O");
        }
    }

    protected void concactProperties(File in, File out) throws IOException {
        PluginHelper.SortedProperties propertiesIn = new PluginHelper.SortedProperties(this.encoding).load(in);
        PluginHelper.SortedProperties propertiesOut = new PluginHelper.SortedProperties(this.encoding).load(out);
        propertiesOut.putAll((Map)propertiesIn);
        propertiesOut.store(out);
    }
}

